/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.scissors.skin;

import java.awt.image.BufferedImage;
import net.skinsrestorer.scissors.RectangleSection;

public enum SkinVariant {
    CLASSIC,
    SLIM;

    public static final RectangleSection SLIM_TRANSPARENT_RIGHT_ARM_SECTION;
    public static final RectangleSection SLIM_TRANSPARENT_LEFT_ARM_SECTION;
    public static final SkinVariant[] VALUES;

    public static SkinVariant detectVariant(BufferedImage image) {
        return SkinVariant.isSlim(image) ? SLIM : CLASSIC;
    }

    public static boolean isSlim(BufferedImage image) {
        return SkinVariant.anyTransparentPixel(image, SLIM_TRANSPARENT_RIGHT_ARM_SECTION) || SkinVariant.anyTransparentPixel(image, SLIM_TRANSPARENT_LEFT_ARM_SECTION);
    }

    private static boolean anyTransparentPixel(BufferedImage image, RectangleSection section) {
        return section.coordinateStream().anyMatch(pixel -> {
            int rgb = image.getRGB(pixel.x(), pixel.y());
            return (rgb & 0xFF000000) == 0;
        });
    }

    static {
        SLIM_TRANSPARENT_RIGHT_ARM_SECTION = new RectangleSection(54, 20, 2, 12);
        SLIM_TRANSPARENT_LEFT_ARM_SECTION = new RectangleSection(46, 52, 2, 12);
        VALUES = SkinVariant.values();
    }
}

