/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.bungee;

import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.plugin.Plugin;
import net.skinsrestorer.shadow.cloud.CommandManager;
import net.skinsrestorer.shadow.cloud.SenderMapper;
import net.skinsrestorer.shadow.cloud.SenderMapperHolder;
import net.skinsrestorer.shadow.cloud.bungee.BungeeCaptionKeys;
import net.skinsrestorer.shadow.cloud.bungee.BungeeCommandPreprocessor;
import net.skinsrestorer.shadow.cloud.bungee.BungeePluginRegistrationHandler;
import net.skinsrestorer.shadow.cloud.bungee.parser.PlayerParser;
import net.skinsrestorer.shadow.cloud.bungee.parser.ServerParser;
import net.skinsrestorer.shadow.cloud.caption.Caption;
import net.skinsrestorer.shadow.cloud.caption.CaptionProvider;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.cloud.execution.ExecutionCoordinator;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BungeeCommandManager<C>
extends CommandManager<C>
implements SenderMapperHolder<CommandSender, C> {
    public static final String ARGUMENT_PARSE_FAILURE_PLAYER = "'<input>' is not a valid player";
    public static final String ARGUMENT_PARSE_FAILURE_SERVER = "'<input>' is not a valid server";
    private final Plugin owningPlugin;
    private final SenderMapper<CommandSender, C> senderMapper;

    public BungeeCommandManager(@NonNull Plugin owningPlugin, @NonNull ExecutionCoordinator<C> commandExecutionCoordinator, @NonNull SenderMapper<CommandSender, C> senderMapper) {
        super(commandExecutionCoordinator, new BungeePluginRegistrationHandler());
        ((BungeePluginRegistrationHandler)this.commandRegistrationHandler()).initialize(this);
        this.owningPlugin = owningPlugin;
        this.senderMapper = senderMapper;
        this.registerCommandPreProcessor(new BungeeCommandPreprocessor(this));
        this.parserRegistry().registerParser(PlayerParser.playerParser()).registerParser(ServerParser.serverParser());
        this.captionRegistry().registerProvider(CaptionProvider.constantProvider().putCaption(BungeeCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, ARGUMENT_PARSE_FAILURE_PLAYER).putCaption(BungeeCaptionKeys.ARGUMENT_PARSE_FAILURE_SERVER, ARGUMENT_PARSE_FAILURE_SERVER).build());
        this.registerDefaultExceptionHandlers();
    }

    @Override
    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        if (permission.isEmpty()) {
            return true;
        }
        return this.senderMapper.reverse(sender).hasPermission(permission);
    }

    public @NonNull Plugin owningPlugin() {
        return this.owningPlugin;
    }

    private void registerDefaultExceptionHandlers() {
        this.registerDefaultExceptionHandlers(triplet -> {
            CommandSender commandSender = this.senderMapper.reverse(((CommandContext)triplet.first()).sender());
            String message = ((CommandContext)triplet.first()).formatCaption((Caption)triplet.second(), (List)triplet.third());
            commandSender.sendMessage(new ComponentBuilder(message).color(ChatColor.RED).create());
        }, pair -> this.owningPlugin.getLogger().log(Level.SEVERE, (String)pair.first(), (Throwable)pair.second()));
    }

    @Override
    public final @NonNull SenderMapper<CommandSender, C> senderMapper() {
        return this.senderMapper;
    }
}

