/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.injection;

import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.cloud.injection.InjectionRequestImpl;
import net.skinsrestorer.shadow.cloud.util.annotation.AnnotationAccessor;
import net.skinsrestorer.shadow.geantyref.GenericTypeReflector;
import net.skinsrestorer.shadow.geantyref.TypeToken;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.immutables.value.Value;

@API(status=API.Status.STABLE)
@Value.Immutable
public interface InjectionRequest<C> {
    public static <C> @NonNull InjectionRequest<C> of(@NonNull CommandContext<C> context, @NonNull TypeToken<?> injectedType, @NonNull AnnotationAccessor annotationAccessor) {
        return InjectionRequestImpl.of(context, injectedType, annotationAccessor);
    }

    public static <C> @NonNull InjectionRequest<C> of(@NonNull CommandContext<C> context, @NonNull TypeToken<?> injectedType) {
        return InjectionRequestImpl.of(context, injectedType, AnnotationAccessor.empty());
    }

    public @NonNull CommandContext<C> commandContext();

    public @NonNull TypeToken<?> injectedType();

    @Value.Derived
    default public @NonNull Class<?> injectedClass() {
        return GenericTypeReflector.erase(this.injectedType().getType());
    }

    public @NonNull AnnotationAccessor annotationAccessor();
}

