/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.cooldown.listener;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.skinsrestorer.shadow.cloud.Command;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownGroup;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownInstance;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownRepository;
import net.skinsrestorer.shadow.cloud.processors.cooldown.listener.CooldownCreationListener;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@API(status=API.Status.STABLE, since="1.0.0")
@NestMembers(value={CooldownDeletionTask.class})
public final class ScheduledCleanupCreationListener<C>
implements CooldownCreationListener<C> {
    private final ScheduledExecutorService executorService;
    private final CooldownRepository<C> cooldownRepository;

    public ScheduledCleanupCreationListener(@NonNull ScheduledExecutorService executorService, @NonNull CooldownRepository<C> cooldownRepository) {
        this.executorService = executorService;
        this.cooldownRepository = cooldownRepository;
    }

    @Override
    public void cooldownCreated(@NonNull C sender, @NonNull Command<C> command, @NonNull CooldownInstance instance) {
        this.executorService.schedule(new CooldownDeletionTask(sender, instance.group()), instance.duration().toMillis(), TimeUnit.MILLISECONDS);
    }

    public /* synthetic */ CooldownRepository jvmdowngrader$nest$net_skinsrestorer_shadow_cloud_processors_cooldown_listener_ScheduledCleanupCreationListener$get$cooldownRepository() {
        return this.cooldownRepository;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_shadow_cloud_processors_cooldown_listener_ScheduledCleanupCreationListener$set$cooldownRepository(CooldownRepository cooldownRepository) {
        this.cooldownRepository = cooldownRepository;
    }

    @NestHost(value=ScheduledCleanupCreationListener.class)
    private final class CooldownDeletionTask
    implements Runnable {
        private final C sender;
        private final CooldownGroup group;

        CooldownDeletionTask(@NonNull C sender, CooldownGroup group) {
            this.sender = sender;
            this.group = group;
        }

        @Override
        public void run() {
            ScheduledCleanupCreationListener.this.jvmdowngrader$nest$net_skinsrestorer_shadow_cloud_processors_cooldown_listener_ScheduledCleanupCreationListener$get$cooldownRepository().deleteCooldown(this.sender, this.group);
        }
    }
}

