/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.injector.handlers.instantiation;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.skinsrestorer.shadow.injector.context.ResolutionContext;
import net.skinsrestorer.shadow.injector.context.StandardResolutionType;
import net.skinsrestorer.shadow.injector.handlers.Handler;
import net.skinsrestorer.shadow.injector.handlers.instantiation.Resolution;
import net.skinsrestorer.shadow.javax.annotation.Nullable;

public class InstantiationCache
implements Handler {
    protected Map<Class, WeakReference<Resolution>> entries = new ConcurrentHashMap<Class, WeakReference<Resolution>>();

    @Override
    public Resolution<?> resolve(ResolutionContext context) {
        return this.getInstantiation(context);
    }

    @Override
    public <T> T postProcess(T object, ResolutionContext context, Resolution<?> resolution) {
        if (this.shouldCacheMethod(context) && this.getInstantiation(context) == null) {
            this.entries.put(context.getIdentifier().getTypeAsClass(), new WeakReference(resolution));
        }
        return null;
    }

    @Nullable
    private <T> Resolution<? extends T> getInstantiation(ResolutionContext context) {
        WeakReference<Resolution> instantiation = this.entries.get(context.getIdentifier().getTypeAsClass());
        return instantiation == null ? null : (Resolution)instantiation.get();
    }

    protected boolean shouldCacheMethod(ResolutionContext context) {
        return context.getIdentifier().getResolutionType() == StandardResolutionType.REQUEST_SCOPED;
    }
}

