/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.injector.testing.runner;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.skinsrestorer.shadow.injector.context.ResolutionContext;
import net.skinsrestorer.shadow.injector.handlers.Handler;
import net.skinsrestorer.shadow.injector.handlers.instantiation.Resolution;
import net.skinsrestorer.shadow.injector.handlers.instantiation.SimpleResolution;
import net.skinsrestorer.shadow.injector.testing.InjectDelayed;
import net.skinsrestorer.shadow.injector.utils.ReflectionUtils;
import net.skinsrestorer.shadow.javax.annotation.Nullable;
import net.skinsrestorer.shadow.javax.inject.Inject;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.TestClass;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Spy;

public class AnnotationResolver
implements Handler {
    private final TestClass testClass;
    private final Object target;
    private final Set<Class<? extends Annotation>> ignoredAnnotations;

    public AnnotationResolver(TestClass testClass, Object target) {
        this(testClass, target, Inject.class, InjectMocks.class, Mock.class, Spy.class, InjectDelayed.class);
    }

    @SafeVarargs
    public AnnotationResolver(TestClass testClass, Object target, Class<? extends Annotation> ... ignoredAnnotations) {
        this.testClass = testClass;
        this.target = target;
        this.ignoredAnnotations = Collections.unmodifiableSet(new HashSet<Class<? extends Annotation>>(Arrays.asList(ignoredAnnotations)));
    }

    @Override
    public Resolution<?> resolve(ResolutionContext context) {
        Class<?> clazz = context.getIdentifier().getTypeAsClass();
        for (Annotation annotation : context.getIdentifier().getAnnotations()) {
            Object o = this.resolveByAnnotation(annotation.annotationType(), clazz);
            if (o == null) continue;
            return new SimpleResolution<Object>(o);
        }
        return null;
    }

    @Nullable
    private Object resolveByAnnotation(Class<? extends Annotation> annotation, Class<?> type) {
        if (!this.ignoredAnnotations.contains(annotation)) {
            List fields = this.testClass.getAnnotatedFields(annotation);
            for (FrameworkField field : fields) {
                if (!type.isAssignableFrom(field.getType())) continue;
                return ReflectionUtils.getFieldValue(field.getField(), this.target);
            }
        }
        return null;
    }
}

