/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.context;

import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.HostAddress;
import net.skinsrestorer.shadow.mariadb.client.PrepareCache;
import net.skinsrestorer.shadow.mariadb.client.context.BaseContext;
import net.skinsrestorer.shadow.mariadb.client.impl.TransactionSaver;
import net.skinsrestorer.shadow.mariadb.export.ExceptionFactory;
import net.skinsrestorer.shadow.mariadb.message.ClientMessage;
import net.skinsrestorer.shadow.mariadb.message.client.RedoableClientMessage;
import net.skinsrestorer.shadow.mariadb.message.server.InitialHandshakePacket;

public class RedoContext
extends BaseContext {
    private final TransactionSaver transactionSaver;

    public RedoContext(HostAddress hostAddress, InitialHandshakePacket handshake, long clientCapabilities, Configuration conf, ExceptionFactory exceptionFactory, PrepareCache prepareCache, Boolean loopbackAddress) {
        super(hostAddress, handshake, clientCapabilities, conf, exceptionFactory, prepareCache, loopbackAddress);
        this.transactionSaver = new TransactionSaver(conf.transactionReplaySize());
    }

    @Override
    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
        if ((serverStatus & 1) == 0) {
            this.transactionSaver.clear();
        }
    }

    public void saveRedo(ClientMessage msg) {
        if (msg instanceof RedoableClientMessage) {
            RedoableClientMessage redoMsg = (RedoableClientMessage)msg;
            redoMsg.saveParameters();
            this.transactionSaver.add(redoMsg);
        }
    }

    public void saveRedo(ClientMessage[] msgs) {
        for (ClientMessage msg : msgs) {
            this.saveRedo(msg);
        }
    }

    public TransactionSaver getTransactionSaver() {
        return this.transactionSaver;
    }
}

