/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.plugin.authentication;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.ServiceLoader;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.Driver;
import net.skinsrestorer.shadow.mariadb.plugin.AuthenticationPluginFactory;

public final class AuthenticationPluginLoader {
    private AuthenticationPluginLoader() {
    }

    public static AuthenticationPluginFactory get(String type, Configuration conf) throws SQLException {
        ServiceLoader<AuthenticationPluginFactory> loader = ServiceLoader.load(AuthenticationPluginFactory.class, Driver.class.getClassLoader());
        String[] authList = conf.restrictedAuth() != null ? conf.restrictedAuth().split(",") : null;
        for (AuthenticationPluginFactory implClass : loader) {
            block4: {
                block3: {
                    if (!type.equals(implClass.type())) continue;
                    if (authList == null) break block3;
                    if (!Arrays.stream(authList).anyMatch(type::contains)) break block4;
                }
                return implClass;
            }
            throw new SQLException(String.format("Client restrict authentication plugin to a limited set of authentication plugin and doesn't permit requested plugin ('%s'). Current list is `restrictedAuth=%s`", type, conf.restrictedAuth()), "08004", 1251);
        }
        throw new SQLException("Client does not support authentication protocol requested by server. plugin type was = '" + type + "'", "08004", 1251);
    }
}

