/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.util.timeout;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.skinsrestorer.shadow.mariadb.Connection;
import net.skinsrestorer.shadow.mariadb.client.util.ClosableLock;
import net.skinsrestorer.shadow.mariadb.client.util.SchedulerProvider;
import net.skinsrestorer.shadow.mariadb.util.timeout.QueryTimeoutHandler;

public class QueryTimeoutHandlerImpl
implements QueryTimeoutHandler {
    private Future<?> timerTaskFuture;
    private ScheduledExecutorService timeoutScheduler;
    private Connection conn;
    private ClosableLock lock;

    @Override
    public QueryTimeoutHandler create(int queryTimeout) {
        assert (this.timerTaskFuture == null);
        if (queryTimeout > 0) {
            if (this.timeoutScheduler == null) {
                this.timeoutScheduler = SchedulerProvider.getTimeoutScheduler(this.lock);
            }
            this.timerTaskFuture = this.timeoutScheduler.schedule(() -> {
                try {
                    this.conn.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, (long)queryTimeout, TimeUnit.SECONDS);
        }
        return this;
    }

    public QueryTimeoutHandlerImpl(Connection conn, ClosableLock lock) {
        this.conn = conn;
        this.lock = lock;
    }

    @Override
    public void close() {
        if (this.timerTaskFuture != null) {
            if (!this.timerTaskFuture.cancel(true)) {
                try {
                    this.timerTaskFuture.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {
                    // empty catch block
                }
            }
            this.timerTaskFuture = null;
        }
    }
}

