/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.List;
import net.skinsrestorer.shadow.reflect.Classes;
import net.skinsrestorer.shadow.reflect.Enums;
import net.skinsrestorer.shadow.reflect.Fields;
import net.skinsrestorer.shadow.reflect.JVMConstants;
import net.skinsrestorer.shadow.reflect.JavaBypass;
import net.skinsrestorer.shadow.reflect.Methods;
import net.skinsrestorer.shadow.reflect.exceptions.MethodNotFoundException;
import net.skinsrestorer.shadow.reflect.stream.RStream;
import net.skinsrestorer.shadow.reflect.utils.FieldInitializer;

public class ClassLoaders {
    private static final MethodHandle defineClass = FieldInitializer.reqInit(() -> Methods.getDeclaredMethod(ClassLoader.class, JVMConstants.METHOD_ClassLoader_defineClass, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class), JavaBypass.TRUSTED_LOOKUP::unreflect, () -> new MethodNotFoundException(ClassLoader.class.getName(), JVMConstants.METHOD_ClassLoader_defineClass, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class));
    private static final Class<?> classOptionClass = FieldInitializer.optInit(() -> Class.forName(JVMConstants.CLASS_MethodHandles_Lookup_ClassOption));
    private static final MethodHandle unsafeDefineAnonymousClass = FieldInitializer.reqOptInit(classOptionClass == null, () -> Methods.getDeclaredMethod(JavaBypass.UNSAFE.getClass(), JVMConstants.METHOD_Unsafe_defineAnonymousClass, Class.class, byte[].class, Object[].class), JavaBypass.TRUSTED_LOOKUP::unreflect, () -> new MethodNotFoundException(JavaBypass.UNSAFE.getClass().getName(), JVMConstants.METHOD_Unsafe_defineAnonymousClass, Class.class, byte[].class, Object[].class));
    private static final MethodHandle lookupDefineHiddenClass = FieldInitializer.reqOptInit(classOptionClass != null, () -> Methods.getDeclaredMethod(MethodHandles.Lookup.class, JVMConstants.METHOD_MethodHandles_Lookup_defineHiddenClass, byte[].class, Boolean.TYPE, Array.newInstance(classOptionClass, 0).getClass()), m -> JavaBypass.TRUSTED_LOOKUP.unreflect((Method)m).asFixedArity(), () -> new MethodNotFoundException(MethodHandles.Lookup.class.getName(), JVMConstants.METHOD_MethodHandles_Lookup_defineHiddenClass, byte[].class, Boolean.TYPE, Array.newInstance(classOptionClass, 0).getClass()));

    public static void addToSystemClassPath(URL url) {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        Field ucpField = Fields.getDeclaredField(systemClassLoader.getClass(), JVMConstants.FIELD_URLClassLoader_ucp);
        if (ucpField == null) {
            ucpField = Fields.getDeclaredField(systemClassLoader.getClass().getSuperclass(), JVMConstants.FIELD_URLClassLoader_ucp);
        }
        if (ucpField == null) {
            throw new IllegalStateException("Unable to find URLClassPath field of system classloader");
        }
        Object urlClassPath = Fields.getObject(systemClassLoader, ucpField);
        Method addURLMethod = Methods.getDeclaredMethod(ucpField.getType(), JVMConstants.METHOD_URLClassPath_addURL, URL.class);
        Methods.invoke(urlClassPath, addURLMethod, url);
    }

    public static URL[] getSystemClassPath() {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        Field ucpField = Fields.getDeclaredField(systemClassLoader.getClass(), JVMConstants.FIELD_URLClassLoader_ucp);
        if (ucpField == null) {
            ucpField = Fields.getDeclaredField(systemClassLoader.getClass().getSuperclass(), JVMConstants.FIELD_URLClassLoader_ucp);
        }
        if (ucpField == null) {
            throw new IllegalStateException("Unable to find URLClassPath field of system classloader");
        }
        Object urlClassPath = Fields.getObject(systemClassLoader, ucpField);
        Method getURLsMethod = Methods.getDeclaredMethod(urlClassPath.getClass(), JVMConstants.METHOD_URLClassPath_getURLs, new Class[0]);
        return (URL[])Methods.invoke(urlClassPath, getURLsMethod, new Object[0]);
    }

    public static void loadToFront(URL url) {
        URL nonExistentFile;
        Object ucp;
        ClassLoader classLoader;
        block5: {
            classLoader = Thread.currentThread().getContextClassLoader();
            try {
                ucp = RStream.of(classLoader).withSuper().fields().by("ucp").get();
                RStream.of(ucp).methods().by("addURL", URL.class).invokeArgs(url);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to find URLClassPath of classloader", t);
            }
            List path = (List)RStream.of(ucp).fields().by("path").get();
            for (int i = 0; i < path.size(); ++i) {
                if (!url.equals(path.get(i))) continue;
                path.add(0, path.remove(i));
                break block5;
            }
            throw new IllegalStateException("Unable to find URL in classpath");
        }
        while ((nonExistentFile = classLoader.getResource("THIS_FILE_SHOULD_NEVER_EXIST_" + System.nanoTime())) != null) {
        }
        Class<?> jarLoaderClass = Classes.forName(ucp.getClass().getName() + "$JarLoader");
        List loaders = (List)RStream.of(ucp).fields().by("loaders").get();
        for (Object loader : loaders) {
            URL loaderUrl;
            if (!jarLoaderClass.equals(loader.getClass()) || !url.equals(loaderUrl = (URL)RStream.of(loader).fields().filter(URL.class).by(0).get())) continue;
            loaders.add(0, loaders.remove(loaders.size() - 1));
            break;
        }
    }

    public static Class<?> defineClass(ClassLoader classLoader, String name, byte[] bytecode) {
        return ClassLoaders.defineClass(classLoader, name, bytecode, null);
    }

    public static Class<?> defineClass(ClassLoader classLoader, String name, byte[] bytecode, ProtectionDomain protectionDomain) {
        return ClassLoaders.defineClass(classLoader, name, bytecode, 0, bytecode.length, protectionDomain);
    }

    public static Class<?> defineClass(ClassLoader classLoader, String name, byte[] bytecode, int offset, int length, ProtectionDomain protectionDomain) {
        return defineClass.invokeExact(classLoader, name, bytecode, offset, length, protectionDomain);
    }

    public static Class<?> defineAnonymousClass(Class<?> parent, byte[] bytecode, String ... flags) {
        if (classOptionClass == null) {
            return unsafeDefineAnonymousClass.invokeExact(JavaBypass.UNSAFE, parent, bytecode, new Object[0]);
        }
        Object classOptions = Array.newInstance(classOptionClass, flags.length);
        for (int i = 0; i < flags.length; ++i) {
            String flag = flags[i];
            Object classOption = Enums.valueOfIgnoreCase(classOptionClass, flag);
            if (classOption == null) {
                throw new IllegalArgumentException("Unknown class option: " + flag);
            }
            Array.set(classOptions, i, classOption);
        }
        MethodHandles.Lookup lookup = lookupDefineHiddenClass.invoke(JavaBypass.TRUSTED_LOOKUP.in(parent), bytecode, false, classOptions);
        return lookup.lookupClass();
    }
}

