/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.xseries.profiles.objects.cache;

import java.time.Duration;
import net.skinsrestorer.shadow.jbannotations.ApiStatus;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.xseries.profiles.objects.cache.CacheableProfileable;

@ApiStatus.Internal
public abstract class TimedCacheableProfileable
extends CacheableProfileable {
    private long lastUpdate;

    @NotNull
    protected Duration expiresAfter() {
        return Duration.ofHours(6L);
    }

    @Override
    public final boolean hasExpired(boolean renew) {
        Duration expiresAfter = this.expiresAfter();
        if (expiresAfter.isZero()) {
            return false;
        }
        if (super.hasExpired(renew)) {
            return true;
        }
        if (this.cache == null && this.lastError == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        if (this.lastUpdate == 0L) {
            if (renew) {
                this.lastUpdate = now;
            }
            return true;
        }
        long diff = now - this.lastUpdate;
        if (diff >= expiresAfter.toMillis()) {
            if (renew) {
                this.lastUpdate = now;
            }
            return true;
        }
        return false;
    }
}

