/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.xseries.reflection.minecraft;

import net.skinsrestorer.shadow.ijannotations.Pattern;
import net.skinsrestorer.shadow.xseries.reflection.XReflection;
import net.skinsrestorer.shadow.xseries.reflection.jvm.classes.PackageHandle;

public enum MinecraftPackage implements PackageHandle
{
    NMS(XReflection.NMS_PACKAGE),
    CB(XReflection.CRAFTBUKKIT_PACKAGE),
    BUKKIT("org.bukkit"),
    SPIGOT("org.spigotmc");

    private final String packageId;

    private MinecraftPackage(String packageName) {
        this.packageId = packageName;
    }

    @Override
    public String packageId() {
        return this.name();
    }

    @Override
    public String getBasePackageName() {
        return this.packageId;
    }

    @Override
    public String getPackage(@Pattern(value="(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") String packageName) {
        if (packageName.startsWith(".") || packageName.endsWith(".")) {
            throw new IllegalArgumentException("Package name must not start or end with a dot: " + packageName + " (" + this + ')');
        }
        if (!packageName.isEmpty() && (this != NMS || XReflection.supports(17))) {
            return this.packageId + '.' + packageName;
        }
        return this.packageId;
    }
}

