/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.codec;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shared.codec.BuiltInCodecs;
import net.skinsrestorer.shared.codec.NetworkCodec;
import net.skinsrestorer.shared.codec.NetworkId;
import net.skinsrestorer.shared.codec.SROutputWriter;
import net.skinsrestorer.shared.gui.SRInventory;
import net.skinsrestorer.shared.subjects.messages.ComponentString;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j17.PermittedSubClasses;

@RecordComponents(value={@RecordComponents.Value(name="channelPayload", type=ChannelPayload.class)})
@NestMembers(value={UnknownChannelPayload.class, GiveSkullChannelPayload.class, SkinUpdateV3ChannelPayload.class, SkinUpdateV3ChannelPayload.AckPayload.class, SkinUpdateV2ChannelPayload.class, GUIPageChannelPayload.class, ChannelPayload.class, ChannelType.class})
public final class SRServerPluginMessage
extends J_L_Record {
    private final ChannelPayload<?> channelPayload;
    public static final NetworkCodec<SRServerPluginMessage> CODEC = NetworkCodec.of((out, msg) -> {
        ChannelType.CODEC.write(out, msg.channelPayload().getType());
        msg.channelPayload().writeCodec(out);
    }, in -> new SRServerPluginMessage((ChannelPayload)ChannelType.CODEC.read(in).codec().read(in)));

    public SRServerPluginMessage(ChannelPayload<?> channelPayload) {
        this.channelPayload = channelPayload;
    }

    @Override
    public final String toString() {
        return SRServerPluginMessage.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return SRServerPluginMessage.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return SRServerPluginMessage.jvmdowngrader$equals$equals(this, o);
    }

    public ChannelPayload<?> channelPayload() {
        return this.channelPayload;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(SRServerPluginMessage sRServerPluginMessage) {
        SRServerPluginMessage sRServerPluginMessage2 = sRServerPluginMessage;
        return "SRServerPluginMessage[" + "channelPayload=" + sRServerPluginMessage.channelPayload + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(SRServerPluginMessage sRServerPluginMessage) {
        Object[] objectArray = new Object[]{sRServerPluginMessage.channelPayload};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(SRServerPluginMessage sRServerPluginMessage, Object object) {
        if (sRServerPluginMessage == object) {
            return true;
        }
        if (object != null && object instanceof SRServerPluginMessage) {
            SRServerPluginMessage sRServerPluginMessage2 = (SRServerPluginMessage)object;
            if (Objects.equals(sRServerPluginMessage.channelPayload, sRServerPluginMessage2.channelPayload)) {
                return true;
            }
        }
        return false;
    }

    @PermittedSubClasses(value={GUIPageChannelPayload.class, SkinUpdateV2ChannelPayload.class, SkinUpdateV3ChannelPayload.class, GiveSkullChannelPayload.class, UnknownChannelPayload.class})
    @NestHost(value=SRServerPluginMessage.class)
    public static interface ChannelPayload<T extends ChannelPayload<T>> {
        public ChannelType<T> getType();

        public T cast();

        default public void writeCodec(SROutputWriter out) {
            this.getType().codec().write(out, this.cast());
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="channelName", type=String.class), @RecordComponents.Value(name="codec", type=NetworkCodec.class)})
    @NestHost(value=SRServerPluginMessage.class)
    public static final class ChannelType<T extends ChannelPayload<T>>
    extends J_L_Record
    implements NetworkId {
        private final String channelName;
        private final NetworkCodec<T> codec;
        private static final Map<String, ChannelType<?>> ID_TO_VALUE = new HashMap();
        public static final ChannelType<GUIPageChannelPayload> OPEN_GUI = ChannelType.register(new ChannelType<GUIPageChannelPayload>("openGUI", GUIPageChannelPayload.CODEC));
        public static final ChannelType<SkinUpdateV2ChannelPayload> SKIN_UPDATE_V2 = ChannelType.register(new ChannelType<SkinUpdateV2ChannelPayload>("SkinUpdateV2", SkinUpdateV2ChannelPayload.CODEC));
        public static final ChannelType<SkinUpdateV3ChannelPayload> SKIN_UPDATE_V3 = ChannelType.register(new ChannelType<SkinUpdateV3ChannelPayload>("skinUpdateV3", SkinUpdateV3ChannelPayload.CODEC));
        public static final ChannelType<GiveSkullChannelPayload> GIVE_SKULL = ChannelType.register(new ChannelType<GiveSkullChannelPayload>("giveSkull", GiveSkullChannelPayload.CODEC));
        public static final ChannelType<UnknownChannelPayload> UNKNOWN = ChannelType.register(new ChannelType<UnknownChannelPayload>("unknown", UnknownChannelPayload.CODEC));
        public static final NetworkCodec<ChannelType<?>> CODEC = NetworkCodec.ofNetworkIdDynamic(ID_TO_VALUE, UNKNOWN);

        public ChannelType(String channelName, NetworkCodec<T> codec) {
            this.channelName = channelName;
            this.codec = codec;
        }

        private static <T extends ChannelPayload<T>> ChannelType<T> register(ChannelType<T> channelType) {
            ID_TO_VALUE.put(channelType.getId(), channelType);
            return channelType;
        }

        @Override
        public String getId() {
            return this.channelName;
        }

        @Override
        public final String toString() {
            return ChannelType.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return ChannelType.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return ChannelType.jvmdowngrader$equals$equals(this, o);
        }

        public String channelName() {
            return this.channelName;
        }

        public NetworkCodec<T> codec() {
            return this.codec;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(ChannelType channelType) {
            ChannelType channelType2 = channelType;
            return "SRServerPluginMessage$ChannelType[" + "channelName=" + channelType.channelName + ", " + "codec=" + channelType.codec + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(ChannelType channelType) {
            Object[] objectArray = new Object[]{channelType.channelName, channelType.codec};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(ChannelType channelType, Object object) {
            if (channelType == object) {
                return true;
            }
            if (object != null && object instanceof ChannelType) {
                ChannelType channelType2 = (ChannelType)object;
                if (Objects.equals(channelType.channelName, channelType2.channelName) && Objects.equals(channelType.codec, channelType2.codec)) {
                    return true;
                }
            }
            return false;
        }
    }

    @NestHost(value=SRServerPluginMessage.class)
    public static final class UnknownChannelPayload
    extends J_L_Record
    implements ChannelPayload<UnknownChannelPayload> {
        public static final NetworkCodec<UnknownChannelPayload> CODEC = NetworkCodec.unit(new UnknownChannelPayload());

        @Override
        public ChannelType<UnknownChannelPayload> getType() {
            return ChannelType.UNKNOWN;
        }

        @Override
        public UnknownChannelPayload cast() {
            return this;
        }

        @Override
        public final String toString() {
            return UnknownChannelPayload.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return UnknownChannelPayload.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return UnknownChannelPayload.jvmdowngrader$equals$equals(this, o);
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(UnknownChannelPayload unknownChannelPayload) {
            UnknownChannelPayload unknownChannelPayload2 = unknownChannelPayload;
            return "SRServerPluginMessage$UnknownChannelPayload[" + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(UnknownChannelPayload unknownChannelPayload) {
            Object[] objectArray = new Object[]{};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(UnknownChannelPayload unknownChannelPayload, Object object) {
            if (unknownChannelPayload == object) {
                return true;
            }
            if (object != null && object instanceof UnknownChannelPayload) {
                UnknownChannelPayload unknownChannelPayload2 = (UnknownChannelPayload)object;
                return true;
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="displayName", type=ComponentString.class), @RecordComponents.Value(name="textureHash", type=String.class)})
    @NestHost(value=SRServerPluginMessage.class)
    public static final class GiveSkullChannelPayload
    extends J_L_Record
    implements ChannelPayload<GiveSkullChannelPayload> {
        private final ComponentString displayName;
        private final String textureHash;
        public static final NetworkCodec<GiveSkullChannelPayload> CODEC = NetworkCodec.list(ComponentString.CODEC, GiveSkullChannelPayload::displayName, BuiltInCodecs.STRING_CODEC, GiveSkullChannelPayload::textureHash, GiveSkullChannelPayload::new);

        public GiveSkullChannelPayload(ComponentString displayName, String textureHash) {
            this.displayName = displayName;
            this.textureHash = textureHash;
        }

        @Override
        public ChannelType<GiveSkullChannelPayload> getType() {
            return ChannelType.GIVE_SKULL;
        }

        @Override
        public GiveSkullChannelPayload cast() {
            return this;
        }

        @Override
        public final String toString() {
            return GiveSkullChannelPayload.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return GiveSkullChannelPayload.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return GiveSkullChannelPayload.jvmdowngrader$equals$equals(this, o);
        }

        public ComponentString displayName() {
            return this.displayName;
        }

        public String textureHash() {
            return this.textureHash;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(GiveSkullChannelPayload giveSkullChannelPayload) {
            GiveSkullChannelPayload giveSkullChannelPayload2 = giveSkullChannelPayload;
            return "SRServerPluginMessage$GiveSkullChannelPayload[" + "displayName=" + giveSkullChannelPayload.displayName + ", " + "textureHash=" + giveSkullChannelPayload.textureHash + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(GiveSkullChannelPayload giveSkullChannelPayload) {
            Object[] objectArray = new Object[]{giveSkullChannelPayload.displayName, giveSkullChannelPayload.textureHash};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(GiveSkullChannelPayload giveSkullChannelPayload, Object object) {
            if (giveSkullChannelPayload == object) {
                return true;
            }
            if (object != null && object instanceof GiveSkullChannelPayload) {
                GiveSkullChannelPayload giveSkullChannelPayload2 = (GiveSkullChannelPayload)object;
                if (Objects.equals(giveSkullChannelPayload.displayName, giveSkullChannelPayload2.displayName) && Objects.equals(giveSkullChannelPayload.textureHash, giveSkullChannelPayload2.textureHash)) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="skinProperty", type=SkinProperty.class), @RecordComponents.Value(name="ackPayload", type=Optional.class)})
    @NestHost(value=SRServerPluginMessage.class)
    public static final class SkinUpdateV3ChannelPayload
    extends J_L_Record
    implements ChannelPayload<SkinUpdateV3ChannelPayload> {
        private final SkinProperty skinProperty;
        private final Optional<AckPayload> ackPayload;
        public static final NetworkCodec<SkinUpdateV3ChannelPayload> CODEC = NetworkCodec.list(BuiltInCodecs.SKIN_PROPERTY_CODEC, SkinUpdateV3ChannelPayload::skinProperty, AckPayload.CODEC.optional(), SkinUpdateV3ChannelPayload::ackPayload, SkinUpdateV3ChannelPayload::new);

        public SkinUpdateV3ChannelPayload(SkinProperty skinProperty, Optional<AckPayload> ackPayload) {
            this.skinProperty = skinProperty;
            this.ackPayload = ackPayload;
        }

        @Override
        public ChannelType<SkinUpdateV3ChannelPayload> getType() {
            return ChannelType.SKIN_UPDATE_V3;
        }

        @Override
        public SkinUpdateV3ChannelPayload cast() {
            return this;
        }

        @Override
        public final String toString() {
            return SkinUpdateV3ChannelPayload.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return SkinUpdateV3ChannelPayload.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return SkinUpdateV3ChannelPayload.jvmdowngrader$equals$equals(this, o);
        }

        public SkinProperty skinProperty() {
            return this.skinProperty;
        }

        public Optional<AckPayload> ackPayload() {
            return this.ackPayload;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(SkinUpdateV3ChannelPayload skinUpdateV3ChannelPayload) {
            SkinUpdateV3ChannelPayload skinUpdateV3ChannelPayload2 = skinUpdateV3ChannelPayload;
            return "SRServerPluginMessage$SkinUpdateV3ChannelPayload[" + "skinProperty=" + skinUpdateV3ChannelPayload.skinProperty + ", " + "ackPayload=" + skinUpdateV3ChannelPayload.ackPayload + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(SkinUpdateV3ChannelPayload skinUpdateV3ChannelPayload) {
            Object[] objectArray = new Object[]{skinUpdateV3ChannelPayload.skinProperty, skinUpdateV3ChannelPayload.ackPayload};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(SkinUpdateV3ChannelPayload skinUpdateV3ChannelPayload, Object object) {
            if (skinUpdateV3ChannelPayload == object) {
                return true;
            }
            if (object != null && object instanceof SkinUpdateV3ChannelPayload) {
                SkinUpdateV3ChannelPayload skinUpdateV3ChannelPayload2 = (SkinUpdateV3ChannelPayload)object;
                if (Objects.equals(skinUpdateV3ChannelPayload.skinProperty, skinUpdateV3ChannelPayload2.skinProperty) && Objects.equals(skinUpdateV3ChannelPayload.ackPayload, skinUpdateV3ChannelPayload2.ackPayload)) {
                    return true;
                }
            }
            return false;
        }

        @RecordComponents(value={@RecordComponents.Value(name="ackId", type=UUID.class), @RecordComponents.Value(name="proxySrVersion", type=String.class)})
        @NestHost(value=SRServerPluginMessage.class)
        public static final class AckPayload
        extends J_L_Record {
            private final UUID ackId;
            private final String proxySrVersion;
            public static final NetworkCodec<AckPayload> CODEC = NetworkCodec.list(BuiltInCodecs.UUID_CODEC, AckPayload::ackId, BuiltInCodecs.STRING_CODEC, AckPayload::proxySrVersion, AckPayload::new);

            public AckPayload(UUID ackId, String proxySrVersion) {
                this.ackId = ackId;
                this.proxySrVersion = proxySrVersion;
            }

            @Override
            public final String toString() {
                return AckPayload.jvmdowngrader$toString$toString(this);
            }

            @Override
            public final int hashCode() {
                return AckPayload.jvmdowngrader$hashCode$hashCode(this);
            }

            @Override
            public final boolean equals(Object o) {
                return AckPayload.jvmdowngrader$equals$equals(this, o);
            }

            public UUID ackId() {
                return this.ackId;
            }

            public String proxySrVersion() {
                return this.proxySrVersion;
            }

            private static /* synthetic */ String jvmdowngrader$toString$toString(AckPayload ackPayload) {
                AckPayload ackPayload2 = ackPayload;
                return "SRServerPluginMessage$SkinUpdateV3ChannelPayload$AckPayload[" + "ackId=" + ackPayload.ackId + ", " + "proxySrVersion=" + ackPayload.proxySrVersion + "]";
            }

            private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(AckPayload ackPayload) {
                Object[] objectArray = new Object[]{ackPayload.ackId, ackPayload.proxySrVersion};
                return Arrays.hashCode(objectArray);
            }

            private static /* synthetic */ boolean jvmdowngrader$equals$equals(AckPayload ackPayload, Object object) {
                if (ackPayload == object) {
                    return true;
                }
                if (object != null && object instanceof AckPayload) {
                    AckPayload ackPayload2 = (AckPayload)object;
                    if (Objects.equals(ackPayload.ackId, ackPayload2.ackId) && Objects.equals(ackPayload.proxySrVersion, ackPayload2.proxySrVersion)) {
                        return true;
                    }
                }
                return false;
            }
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="skinProperty", type=SkinProperty.class)})
    @NestHost(value=SRServerPluginMessage.class)
    public static final class SkinUpdateV2ChannelPayload
    extends J_L_Record
    implements ChannelPayload<SkinUpdateV2ChannelPayload> {
        private final SkinProperty skinProperty;
        public static final NetworkCodec<SkinUpdateV2ChannelPayload> CODEC = NetworkCodec.list(BuiltInCodecs.SKIN_PROPERTY_CODEC, SkinUpdateV2ChannelPayload::skinProperty, SkinUpdateV2ChannelPayload::new);

        public SkinUpdateV2ChannelPayload(SkinProperty skinProperty) {
            this.skinProperty = skinProperty;
        }

        @Override
        public ChannelType<SkinUpdateV2ChannelPayload> getType() {
            return ChannelType.SKIN_UPDATE_V2;
        }

        @Override
        public SkinUpdateV2ChannelPayload cast() {
            return this;
        }

        @Override
        public final String toString() {
            return SkinUpdateV2ChannelPayload.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return SkinUpdateV2ChannelPayload.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return SkinUpdateV2ChannelPayload.jvmdowngrader$equals$equals(this, o);
        }

        public SkinProperty skinProperty() {
            return this.skinProperty;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(SkinUpdateV2ChannelPayload skinUpdateV2ChannelPayload) {
            SkinUpdateV2ChannelPayload skinUpdateV2ChannelPayload2 = skinUpdateV2ChannelPayload;
            return "SRServerPluginMessage$SkinUpdateV2ChannelPayload[" + "skinProperty=" + skinUpdateV2ChannelPayload.skinProperty + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(SkinUpdateV2ChannelPayload skinUpdateV2ChannelPayload) {
            Object[] objectArray = new Object[]{skinUpdateV2ChannelPayload.skinProperty};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(SkinUpdateV2ChannelPayload skinUpdateV2ChannelPayload, Object object) {
            if (skinUpdateV2ChannelPayload == object) {
                return true;
            }
            if (object != null && object instanceof SkinUpdateV2ChannelPayload) {
                SkinUpdateV2ChannelPayload skinUpdateV2ChannelPayload2 = (SkinUpdateV2ChannelPayload)object;
                if (Objects.equals(skinUpdateV2ChannelPayload.skinProperty, skinUpdateV2ChannelPayload2.skinProperty)) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="srInventory", type=SRInventory.class)})
    @NestHost(value=SRServerPluginMessage.class)
    public static final class GUIPageChannelPayload
    extends J_L_Record
    implements ChannelPayload<GUIPageChannelPayload> {
        private final SRInventory srInventory;
        public static final NetworkCodec<GUIPageChannelPayload> CODEC = NetworkCodec.list(SRInventory.CODEC, GUIPageChannelPayload::srInventory, GUIPageChannelPayload::new);

        public GUIPageChannelPayload(SRInventory srInventory) {
            this.srInventory = srInventory;
        }

        @Override
        public ChannelType<GUIPageChannelPayload> getType() {
            return ChannelType.OPEN_GUI;
        }

        @Override
        public GUIPageChannelPayload cast() {
            return this;
        }

        @Override
        public final String toString() {
            return GUIPageChannelPayload.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return GUIPageChannelPayload.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return GUIPageChannelPayload.jvmdowngrader$equals$equals(this, o);
        }

        public SRInventory srInventory() {
            return this.srInventory;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(GUIPageChannelPayload gUIPageChannelPayload) {
            GUIPageChannelPayload gUIPageChannelPayload2 = gUIPageChannelPayload;
            return "SRServerPluginMessage$GUIPageChannelPayload[" + "srInventory=" + gUIPageChannelPayload.srInventory + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(GUIPageChannelPayload gUIPageChannelPayload) {
            Object[] objectArray = new Object[]{gUIPageChannelPayload.srInventory};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(GUIPageChannelPayload gUIPageChannelPayload, Object object) {
            if (gUIPageChannelPayload == object) {
                return true;
            }
            if (object != null && object instanceof GUIPageChannelPayload) {
                GUIPageChannelPayload gUIPageChannelPayload2 = (GUIPageChannelPayload)object;
                if (Objects.equals(gUIPageChannelPayload.srInventory, gUIPageChannelPayload2.srInventory)) {
                    return true;
                }
            }
            return false;
        }
    }
}

