/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.connections.MineSkinAPI;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.property.InputDataResult;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.cloud.annotation.specifier.Greedy;
import net.skinsrestorer.shadow.cloud.annotation.specifier.Quoted;
import net.skinsrestorer.shadow.cloud.annotations.Argument;
import net.skinsrestorer.shadow.cloud.annotations.Command;
import net.skinsrestorer.shadow.cloud.annotations.suggestion.Suggestions;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.cloud.help.result.CommandEntry;
import net.skinsrestorer.shadow.cloud.minecraft.extras.MinecraftHelp;
import net.skinsrestorer.shadow.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownGroup;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_C_TimeUnit;
import net.skinsrestorer.shadow.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.object.ObjectContents;
import net.skinsrestorer.shadow.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.skinsrestorer.shared.api.SharedSkinApplier;
import net.skinsrestorer.shared.codec.SRServerPluginMessage;
import net.skinsrestorer.shared.commands.library.PlayerSelector;
import net.skinsrestorer.shared.commands.library.SRCommandManager;
import net.skinsrestorer.shared.commands.library.annotations.CommandDescription;
import net.skinsrestorer.shared.commands.library.annotations.CommandPermission;
import net.skinsrestorer.shared.commands.library.annotations.RootDescription;
import net.skinsrestorer.shared.commands.library.annotations.SRCooldownGroup;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.connections.RecommendationsState;
import net.skinsrestorer.shared.connections.responses.RecommenationResponse;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.storage.PlayerStorageImpl;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.subjects.permissions.SkinPermissionManager;
import net.skinsrestorer.shared.utils.ValidationUtil;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@Command(value="skull")
@RootDescription(value=Message.HELP_SKULL)
@NestMembers(value={1.class})
public final class SkullCommand {
    public static final String COOLDOWN_GROUP_ID = "skull";
    public static final CooldownGroup COOLDOWN_GROUP = CooldownGroup.named("skull");
    private final SRPlatformAdapter adapter;
    private final SRPlugin plugin;
    private final SettingsManager settings;
    private final SkinStorageImpl skinStorage;
    private final PlayerStorageImpl playerStorage;
    private final SkinsRestorerLocale locale;
    private final SRLogger logger;
    private final SharedSkinApplier<Object> skinApplier;
    private final MineSkinAPI mineSkinAPI;
    private final SRCommandManager commandManager;
    private final RecommendationsState recommendationsState;
    private final SkinPermissionManager permissionManager;

    @Command(value="")
    @CommandPermission(value=PermissionRegistry.SKULL)
    public void rootCommand(SRCommandSender sender) {
        MinecraftHelp.builder().commandManager(this.commandManager.getCommandManager()).audienceProvider(ComponentHelper::commandSenderToAudience).commandPrefix("/skull help").messageProvider(MinecraftHelp.captionMessageProvider(this.commandManager.getCommandManager().captionRegistry(), ComponentCaptionFormatter.miniMessage())).descriptionDecorator((s, d) -> ComponentHelper.convertJsonToComponent(this.locale.getMessageRequired((SRForeign)s, net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Optional.orElseThrow(Message.fromKey(d))))).commandFilter(c -> c.rootComponent().name().equals(COOLDOWN_GROUP_ID) && !c.commandDescription().description().isEmpty()).maxResultsPerPage(Integer.MAX_VALUE).build().queryCommands("", sender);
    }

    @Suggestions(value="help_queries_skull")
    public List<String> suggestHelpQueries(CommandContext<SRCommandSender> ctx, String input) {
        return J_U_S_Stream.toList(this.commandManager.getCommandManager().createHelpHandler().queryRootIndex(ctx.sender()).entries().stream().filter(e -> e.command().rootComponent().name().equals(COOLDOWN_GROUP_ID)).map(CommandEntry::syntax));
    }

    @Command(value="help [query]")
    @CommandPermission(value=PermissionRegistry.SKULL)
    @CommandDescription(value=Message.HELP_SKULL)
    public void commandHelp(SRCommandSender sender, @Argument(suggestions="help_queries_skull") @Greedy String query) {
        MinecraftHelp.builder().commandManager(this.commandManager.getCommandManager()).audienceProvider(ComponentHelper::commandSenderToAudience).commandPrefix("/skull help").messageProvider(MinecraftHelp.captionMessageProvider(this.commandManager.getCommandManager().captionRegistry(), ComponentCaptionFormatter.miniMessage())).descriptionDecorator((s, d) -> ComponentHelper.convertJsonToComponent(this.locale.getMessageRequired((SRForeign)s, net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Optional.orElseThrow(Message.fromKey(d))))).commandFilter(c -> c.rootComponent().name().equals(COOLDOWN_GROUP_ID) && !c.commandDescription().description().isEmpty()).build().queryCommands(query == null ? "" : query, sender);
    }

    @Command(value="<skinName>")
    @CommandPermission(value=PermissionRegistry.SKULL_GET)
    @CommandDescription(value=Message.HELP_SKULL_GET)
    @SRCooldownGroup(value="skull")
    private void onSkullGetShort(SRPlayer player, @Quoted String skinName) {
        this.onSkullGetOther(player, skinName, PlayerSelector.singleton(player), null);
    }

    @Command(value="<skinName> <selector>")
    @CommandPermission(value=PermissionRegistry.SKULL_GET_OTHER)
    @CommandDescription(value=Message.HELP_SKULL_GET_OTHER)
    @SRCooldownGroup(value="skull")
    private void onSkullGetShortOther(SRPlayer player, @Quoted String skinName, PlayerSelector selector) {
        this.onSkullGetOther(player, skinName, selector, null);
    }

    @Command(value="random")
    @CommandPermission(value=PermissionRegistry.SKULL_RANDOM)
    @CommandDescription(value=Message.HELP_SKULL_RANDOM)
    @SRCooldownGroup(value="skull")
    private void onSkullRandom(SRPlayer player) {
        this.onSkullRandomOther(player, PlayerSelector.singleton(player));
    }

    @Command(value="random <selector>")
    @CommandPermission(value=PermissionRegistry.SKULL_RANDOM_OTHER)
    @CommandDescription(value=Message.HELP_SKULL_RANDOM_OTHER)
    @SRCooldownGroup(value="skull")
    private void onSkullRandomOther(SRCommandSender sender, PlayerSelector selector) {
        Optional<RecommenationResponse.SkinInfo> randomRecommendation = this.recommendationsState.getRandomRecommendation();
        if (J_U_Optional.isEmpty(randomRecommendation)) {
            this.logger.warning("No random skins available, skipping");
            return;
        }
        this.onSkullGetOther(sender, SkullCommand.jvmdowngrader$concat$onSkullRandomOther$1(randomRecommendation.get().getSkinId()), selector);
    }

    @Command(value="get|give <skinName>")
    @CommandPermission(value=PermissionRegistry.SKULL_GET)
    @CommandDescription(value=Message.HELP_SKULL_GET)
    @SRCooldownGroup(value="skull")
    private void onSkullGet(SRPlayer player, @Quoted String skinName) {
        this.onSkullGetOther(player, skinName, PlayerSelector.singleton(player));
    }

    @Command(value="get|give <skinName> <selector>")
    @CommandPermission(value=PermissionRegistry.SKULL_GET_OTHER)
    @CommandDescription(value=Message.HELP_SKULL_GET_OTHER)
    @SRCooldownGroup(value="skull")
    private void onSkullGetOther(SRCommandSender sender, @Quoted String skinName, PlayerSelector selector) {
        this.onSkullGetOther(sender, skinName, selector, null);
    }

    @Command(value="get|give <skinName> <selector> <skinVariant>")
    @CommandPermission(value=PermissionRegistry.SKULL_GET_OTHER)
    @CommandDescription(value=Message.HELP_SKULL_GET_OTHER)
    @SRCooldownGroup(value="skull")
    private void onSkullGetOther(SRCommandSender sender, @Quoted String skinName, PlayerSelector selector, SkinVariant skinVariant) {
        for (UUID target : selector.resolve(sender)) {
            Optional<SRPlayer> targetPlayer = this.adapter.getPlayer(sender, target);
            String targetName = targetPlayer.map(SRPlayer::getName).orElseGet(target::toString);
            Optional<SkinProperty> givenSkull = this.giveSkull(sender, target, skinName, skinVariant);
            if (J_U_Optional.isEmpty(givenSkull)) {
                return;
            }
            sender.sendMessage(this.senderEqual(sender, target) ? Message.SUCCESS_SKULL_GET : Message.SUCCESS_SKULL_GET_OTHER, Placeholder.unparsed("name", targetName), Placeholder.unparsed("skin", skinName), Placeholder.component("skin_head", AdvancedConfig.emptyIfPlayerHeadChatObjectsDisabled(this.settings, Component.object(ObjectContents.playerHead().name(targetName).profileProperty(PlayerHeadObjectContents.property("textures", givenSkull.get().getValue(), givenSkull.get().getSignature())).build()))));
        }
    }

    @Command(value="url <url> [skinVariant]")
    @CommandPermission(value=PermissionRegistry.SKULL_GET_URL)
    @CommandDescription(value=Message.HELP_SKULL_GET_URL)
    @SRCooldownGroup(value="skull")
    private void onSkullGetUrl(SRPlayer player, @Quoted String url, @Nullable SkinVariant skinVariant) {
        if (!ValidationUtil.validSkinUrl(url)) {
            player.sendMessage(Message.ERROR_INVALID_URLSKIN);
            return;
        }
        this.onSkullGetOther(player, url, PlayerSelector.singleton(player), skinVariant);
    }

    private Optional<SkinProperty> giveSkull(SRCommandSender sender, UUID target, String skinInput, SkinVariant skinVariant) {
        Optional<Message> noPermissionMessage = this.permissionManager.canSetSkin(sender, skinInput);
        if (noPermissionMessage.isPresent()) {
            sender.sendMessage(noPermissionMessage.get());
            return Optional.empty();
        }
        try {
            String string;
            Optional<InputDataResult> optional;
            if (ValidationUtil.validSkinUrl(skinInput)) {
                sender.sendMessage(Message.MS_UPLOADING_SKIN);
            }
            if (J_U_Optional.isEmpty(optional = this.skinStorage.findOrCreateSkinData(skinInput, skinVariant))) {
                sender.sendMessage(Message.NOT_PREMIUM);
                return Optional.empty();
            }
            Optional<SRPlayer> targetPlayer = this.adapter.getPlayer(sender, target);
            if (J_U_Optional.isEmpty(targetPlayer)) {
                return Optional.empty();
            }
            SkinIdentifier skinIdentifier = optional.get().getIdentifier();
            switch (skinIdentifier.getSkinType()) {
                default: {
                    throw new J_L_MatchException(null, null);
                }
                case PLAYER: 
                case LEGACY: 
                case CUSTOM: {
                    string = skinInput;
                    break;
                }
                case URL: {
                    string = "Custom skull";
                }
            }
            String itemName = string;
            this.adapter.giveSkullItem(targetPlayer.get(), new SRServerPluginMessage.GiveSkullChannelPayload(ComponentHelper.convertPlainToJson(itemName), PropertyUtils.getSkinTextureHash(optional.get().getProperty())));
            this.setCoolDown(sender, CommandConfig.SKULL_GET_COOLDOWN);
            return Optional.of(optional.get().getProperty());
        }
        catch (DataRequestException e) {
            ComponentHelper.sendException(e, sender, this.locale, this.logger);
        }
        catch (MineSkinException e) {
            this.logger.debug(SRLogLevel.SEVERE, J_L_String.formatted("Could not generate skin url: %s", skinInput), e);
            sender.sendMessage(Message.ERROR_INVALID_URLSKIN);
        }
        this.setCoolDown(sender, CommandConfig.SKULL_ERROR_COOLDOWN);
        return Optional.empty();
    }

    private void setCoolDown(SRCommandSender sender, Property<Integer> time) {
        if (sender instanceof SRPlayer) {
            SRPlayer player = (SRPlayer)sender;
            this.commandManager.setCooldown(player, COOLDOWN_GROUP, Duration.of(this.settings.getProperty(time).intValue(), J_U_C_TimeUnit.toChronoUnit(TimeUnit.SECONDS)));
        }
    }

    private boolean senderEqual(SRCommandSender sender, UUID other) {
        if (sender instanceof SRPlayer) {
            SRPlayer player = (SRPlayer)sender;
            return player.getUniqueId().equals(other);
        }
        return false;
    }

    @Inject
    @Generated
    public SkullCommand(SRPlatformAdapter adapter, SRPlugin plugin, SettingsManager settings, SkinStorageImpl skinStorage, PlayerStorageImpl playerStorage, SkinsRestorerLocale locale, SRLogger logger, SharedSkinApplier<Object> skinApplier, MineSkinAPI mineSkinAPI, SRCommandManager commandManager, RecommendationsState recommendationsState, SkinPermissionManager permissionManager) {
        this.adapter = adapter;
        this.plugin = plugin;
        this.settings = settings;
        this.skinStorage = skinStorage;
        this.playerStorage = playerStorage;
        this.locale = locale;
        this.logger = logger;
        this.skinApplier = skinApplier;
        this.mineSkinAPI = mineSkinAPI;
        this.commandManager = commandManager;
        this.recommendationsState = recommendationsState;
        this.permissionManager = permissionManager;
    }

    private static /* synthetic */ String jvmdowngrader$concat$onSkullRandomOther$1(String string) {
        return "sr-recommendation-" + string;
    }
}

