/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.connections.MineSkinAPI;
import net.skinsrestorer.api.connections.model.MineSkinResponse;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Map;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.config.APIConfig;
import net.skinsrestorer.shared.connections.http.HttpClient;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.connections.mineskin.MineSkinVariant;
import net.skinsrestorer.shared.connections.mineskin.MineSkinVisibility;
import net.skinsrestorer.shared.connections.mineskin.requests.MineSkinUrlRequest;
import net.skinsrestorer.shared.connections.mineskin.responses.MineSkinUrlResponse;
import net.skinsrestorer.shared.exception.DataRequestExceptionShared;
import net.skinsrestorer.shared.exception.MineSkinExceptionShared;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SRHelpers;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

@NestMembers(value={1.class, AxolotlErrorResponse.class, AxolotlDecryptResponse.class})
public class MineSkinAPIImpl
implements MineSkinAPI {
    private static final int MAX_RETRIES = 5;
    private static final String MINESKIN_USER_AGENT = "SkinsRestorer/MineSkinAPI";
    private static final URI MINESKIN_ENDPOINT = URI.create("https://api.mineskin.org/v2/generate");
    private static final URI AXOLOTL_DECRYPT_ENDPOINT = URI.create("https://axolotl.skinsrestorer.net/mineskin/decrypt-url");
    private final Semaphore semaphore = new Semaphore(5);
    private final Gson gson = new Gson();
    private final SRLogger logger;
    private final MetricsCounter metricsCounter;
    private final SettingsManager settings;
    private final HttpClient httpClient;
    private final AtomicLong nextRequestAt = new AtomicLong();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MineSkinResponse genSkin(String imageUrl, @Nullable SkinVariant skinVariant) throws DataRequestException, MineSkinException {
        imageUrl = this.decryptAxolotlUrl(imageUrl);
        imageUrl = SRHelpers.sanitizeImageURL(imageUrl);
        try {
            int retryAttempts = 0;
            do {
                this.semaphore.acquire();
                try {
                    Optional<MineSkinResponse> optional;
                    long waitDuration = this.nextRequestAt.get() - System.currentTimeMillis();
                    if (waitDuration > 0L) {
                        this.logger.debug(J_L_String.formatted("[INFO] Waiting %dms before next MineSkin request...", waitDuration));
                        Thread.sleep(waitDuration);
                    }
                    if ((optional = this.genSkinInternal(imageUrl, skinVariant)).isPresent()) {
                        MineSkinResponse mineSkinResponse = optional.get();
                        return mineSkinResponse;
                    }
                }
                catch (IOException e) {
                    this.logger.debug(SRLogLevel.WARNING, J_L_String.formatted("[ERROR] MineSkin Failed! IOException (connection/disk): (%s)", imageUrl), e);
                    throw new DataRequestExceptionShared(e);
                }
                finally {
                    this.semaphore.release();
                }
            } while (++retryAttempts < 5);
            throw new MineSkinExceptionShared(Message.ERROR_MS_API_FAILED, new TagResolver[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DataRequestExceptionShared(e);
        }
    }

    private Optional<MineSkinResponse> genSkinInternal(String imageUrl, @Nullable SkinVariant skinVariant) throws DataRequestException, MineSkinException, IOException {
        HttpResponse httpResponse = this.queryURL(imageUrl, skinVariant);
        this.logger.debug(J_L_String.formatted("MineSkinAPI: Response: %s", httpResponse));
        MineSkinUrlResponse response = httpResponse.getBodyAs(MineSkinUrlResponse.class);
        MineSkinUrlResponse.RateLimit rateLimit = response.getRateLimit();
        if (rateLimit != null) {
            long serverNextRequestAt = System.currentTimeMillis() + rateLimit.getNext().getRelative();
            this.nextRequestAt.updateAndGet(currentValue -> Math.max(currentValue, serverNextRequestAt));
        }
        if (response.isSuccess()) {
            MineSkinUrlResponse.Skin skin = response.getSkin();
            MineSkinUrlResponse.Skin.Texture.Data textureData = skin.getTexture().getData();
            SkinProperty property = SkinProperty.of(textureData.getValue(), textureData.getSignature());
            return Optional.of(MineSkinResponse.of(property, skin.getUuid(), skinVariant, PropertyUtils.getSkinVariant(property)));
        }
        Iterator<MineSkinUrlResponse.Error> iterator = response.getErrors().iterator();
        if (iterator.hasNext()) {
            Optional<MineSkinResponse> optional;
            MineSkinUrlResponse.Error error = iterator.next();
            this.logger.debug(J_L_String.formatted("[ERROR] MineSkin Failed! Reason: %s Image URL: %s", error, imageUrl));
            switch (error.getCode()) {
                case "rate_limit": {
                    optional = Optional.empty();
                    break;
                }
                case "failed_to_create_id": 
                case "skin_change_failed": {
                    this.logger.debug("Trying again in 6 seconds...");
                    long nowPlus = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(6L);
                    this.nextRequestAt.updateAndGet(currentValue -> Math.max(currentValue, nowPlus));
                    optional = Optional.empty();
                    break;
                }
                case "no_account_available": {
                    throw new MineSkinExceptionShared(Message.ERROR_MS_FULL, new TagResolver[0]);
                }
                case "invalid_api_key": {
                    this.logger.severe(J_L_String.formatted("[ERROR] MineSkin API key is invalid! Reason: %s", error));
                    switch (error.getMessage()) {
                        case "Invalid API Key": {
                            this.logger.severe(J_L_String.formatted("The API Key provided is not registered on MineSkin! Please empty \"%s\" in plugins/SkinsRestorer/config.yml and run /sr reload", APIConfig.MINESKIN_API_KEY.getPath()));
                            break;
                        }
                        case "Client not allowed": {
                            this.logger.severe("This server ip is not on the api key allowed IPs list!");
                            break;
                        }
                        case "Origin not allowed": {
                            this.logger.severe("This server Origin is not on the api key allowed Origins list!");
                            break;
                        }
                        case "Agent not allowed": {
                            this.logger.severe(J_L_String.formatted("SkinsRestorer's agent \"%s\" is not on the api key allowed agents list!", MINESKIN_USER_AGENT));
                            break;
                        }
                        default: {
                            this.logger.severe("Unknown error, please report this to SkinsRestorer's Discord!");
                        }
                    }
                    throw new MineSkinExceptionShared(Message.ERROR_MS_API_KEY_INVALID, new TagResolver[0]);
                }
                default: {
                    throw new MineSkinExceptionShared(Message.ERROR_INVALID_URLSKIN, new TagResolver[0]);
                }
            }
            return optional;
        }
        this.logger.debug(J_L_String.formatted("[ERROR] MineSkin Failed! Unknown error: (Image URL: %s) %d", imageUrl, httpResponse.statusCode()));
        throw new MineSkinExceptionShared(Message.ERROR_MS_API_FAILED, new TagResolver[0]);
    }

    private HttpResponse queryURL(String url, @Nullable SkinVariant skinVariant) throws IOException {
        int i = 0;
        while (true) {
            try {
                MineSkinVariant mineSkinVariant;
                this.metricsCounter.increment(MetricsCounter.Service.MINESKIN_CALLS);
                HashMap<String, String> headers = new HashMap<String, String>();
                this.getApiKey(this.settings).ifPresent(s -> headers.put("Authorization", J_L_String.formatted("Bearer %s", s)));
                if (skinVariant == null) {
                    mineSkinVariant = MineSkinVariant.UNKNOWN;
                } else {
                    switch (skinVariant) {
                        default: {
                            throw new J_L_MatchException(null, null);
                        }
                        case CLASSIC: {
                            mineSkinVariant = MineSkinVariant.CLASSIC;
                            break;
                        }
                        case SLIM: {
                            mineSkinVariant = MineSkinVariant.SLIM;
                        }
                    }
                }
                return this.httpClient.execute(MINESKIN_ENDPOINT, new HttpClient.RequestBody(this.gson.toJson(new MineSkinUrlRequest(mineSkinVariant, null, this.settings.getProperty(APIConfig.MINESKIN_SECRET_SKINS) != false ? MineSkinVisibility.UNLISTED : MineSkinVisibility.PUBLIC, null, url)), HttpClient.HttpType.JSON), HttpClient.HttpType.JSON, MINESKIN_USER_AGENT, HttpClient.HttpMethod.POST, headers, 90000);
            }
            catch (IOException e) {
                if (i >= 2) {
                    throw new IOException(e);
                }
                ++i;
                continue;
            }
            break;
        }
    }

    private Optional<String> getApiKey(SettingsManager settings) {
        String apiKey = settings.getProperty(APIConfig.MINESKIN_API_KEY);
        if (apiKey.isEmpty() || apiKey.equals("key")) {
            return Optional.empty();
        }
        return Optional.of(apiKey);
    }

    private String decryptAxolotlUrl(String imageUrl) throws DataRequestException {
        if (!imageUrl.startsWith("skinsrestorer-axolotl://")) {
            return imageUrl;
        }
        try {
            String encodedUrl = MineSkinAPIImpl.jvmdg$inlined$encode(imageUrl, StandardCharsets.UTF_8);
            URI requestUri = URI.create(MineSkinAPIImpl.jvmdowngrader$concat$decryptAxolotlUrl$1(String.valueOf(AXOLOTL_DECRYPT_ENDPOINT), encodedUrl));
            this.logger.debug(J_L_String.formatted("Decrypting axolotl URL: %s", imageUrl));
            HttpResponse response = this.httpClient.execute(requestUri, null, HttpClient.HttpType.JSON, MINESKIN_USER_AGENT, HttpClient.HttpMethod.GET, J_U_Map.of(), 30000);
            if (response.statusCode() == 200) {
                AxolotlDecryptResponse decryptResponse = this.gson.fromJson(response.body(), AxolotlDecryptResponse.class);
                if (decryptResponse.jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlDecryptResponse$get$url() != null && !decryptResponse.jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlDecryptResponse$get$url().isEmpty()) {
                    this.logger.debug(J_L_String.formatted("Successfully decrypted axolotl URL to: %s", decryptResponse.jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlDecryptResponse$get$url()));
                    return decryptResponse.jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlDecryptResponse$get$url();
                }
                this.logger.debug(SRLogLevel.WARNING, "Axolotl decrypt response missing URL field");
                throw new DataRequestExceptionShared(new IOException("Invalid decrypt response: missing URL"));
            }
            if (response.statusCode() == 400) {
                AxolotlErrorResponse errorResponse = this.gson.fromJson(response.body(), AxolotlErrorResponse.class);
                String errorMsg = errorResponse.jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlErrorResponse$get$error() != null ? errorResponse.jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlErrorResponse$get$error() : "Malformed ciphertext";
                this.logger.debug(SRLogLevel.WARNING, J_L_String.formatted("Axolotl decrypt failed (400): %s", errorMsg));
                throw new DataRequestExceptionShared(new IOException(MineSkinAPIImpl.jvmdowngrader$concat$decryptAxolotlUrl$1(errorMsg)));
            }
            if (response.statusCode() == 500) {
                AxolotlErrorResponse errorResponse = this.gson.fromJson(response.body(), AxolotlErrorResponse.class);
                String errorMsg = errorResponse.jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlErrorResponse$get$error() != null ? errorResponse.jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlErrorResponse$get$error() : "Server configuration error";
                this.logger.debug(SRLogLevel.WARNING, J_L_String.formatted("Axolotl decrypt server error (500): %s", errorMsg));
                throw new DataRequestExceptionShared(new IOException(MineSkinAPIImpl.jvmdowngrader$concat$decryptAxolotlUrl$2(errorMsg)));
            }
            this.logger.debug(SRLogLevel.WARNING, J_L_String.formatted("Axolotl decrypt unexpected status: %d", response.statusCode()));
            throw new DataRequestExceptionShared(new IOException(MineSkinAPIImpl.jvmdowngrader$concat$decryptAxolotlUrl$1(response.statusCode())));
        }
        catch (IOException e) {
            this.logger.debug(SRLogLevel.WARNING, "Failed to decrypt axolotl URL", e);
            throw new DataRequestExceptionShared(e);
        }
    }

    @Inject
    @Generated
    public MineSkinAPIImpl(SRLogger logger, MetricsCounter metricsCounter, SettingsManager settings, HttpClient httpClient) {
        this.logger = logger;
        this.metricsCounter = metricsCounter;
        this.settings = settings;
        this.httpClient = httpClient;
    }

    private static /* synthetic */ String jvmdowngrader$concat$decryptAxolotlUrl$1(String string, String string2) {
        return string + "?encryptedUrl=" + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$decryptAxolotlUrl$1(String string) {
        return "Failed to decrypt axolotl URL: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$decryptAxolotlUrl$2(String string) {
        return "Axolotl decrypt service error: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$decryptAxolotlUrl$1(int n) {
        return "Unexpected decrypt response: " + n;
    }

    @Stub(ref=@Ref(value="Ljava/net/URLEncoder;"))
    private static /* synthetic */ String jvmdg$inlined$encode(String s, Charset charset) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, charset.name());
    }

    @NestHost(value=MineSkinAPIImpl.class)
    private static class AxolotlDecryptResponse {
        private String url;

        private AxolotlDecryptResponse() {
        }

        public /* synthetic */ String jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlDecryptResponse$get$url() {
            return this.url;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlDecryptResponse$set$url(String string) {
            this.url = string;
        }
    }

    @NestHost(value=MineSkinAPIImpl.class)
    private static class AxolotlErrorResponse {
        private String error;

        private AxolotlErrorResponse() {
        }

        public /* synthetic */ String jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlErrorResponse$get$error() {
            return this.error;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_shared_connections_MineSkinAPIImpl$AxolotlErrorResponse$set$error(String string) {
            this.error = string;
        }
    }
}

