/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections.http;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.gson.JsonSyntaxException;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shared.exception.DataRequestExceptionShared;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="statusCode", type=int.class), @RecordComponents.Value(name="body", type=String.class), @RecordComponents.Value(name="headers", type=Map.class)})
public final class HttpResponse
extends J_L_Record {
    private final int statusCode;
    private final String body;
    private final Map<String, List<String>> headers;
    private static final Gson GSON = new Gson();

    public HttpResponse(int statusCode, String body, Map<String, List<String>> headers) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
    }

    public <T> T getBodyAs(Class<T> clazz) throws DataRequestException {
        try {
            return GSON.fromJson(this.body, clazz);
        }
        catch (JsonSyntaxException e) {
            throw new DataRequestExceptionShared(e);
        }
    }

    public <T> T getBodyAs(Type type) throws DataRequestException {
        try {
            return GSON.fromJson(this.body, type);
        }
        catch (JsonSyntaxException e) {
            throw new DataRequestExceptionShared(e);
        }
    }

    @Override
    public final String toString() {
        return HttpResponse.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return HttpResponse.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return HttpResponse.jvmdowngrader$equals$equals(this, o);
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String body() {
        return this.body;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(HttpResponse httpResponse) {
        HttpResponse httpResponse2 = httpResponse;
        return "HttpResponse[" + "statusCode=" + httpResponse.statusCode + ", " + "body=" + httpResponse.body + ", " + "headers=" + httpResponse.headers + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(HttpResponse httpResponse) {
        Object[] objectArray = new Object[]{httpResponse.statusCode, httpResponse.body, httpResponse.headers};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(HttpResponse httpResponse, Object object) {
        if (httpResponse == object) {
            return true;
        }
        if (object != null && object instanceof HttpResponse) {
            HttpResponse httpResponse2 = (HttpResponse)object;
            if (httpResponse.statusCode == httpResponse2.statusCode && Objects.equals(httpResponse.body, httpResponse2.body) && Objects.equals(httpResponse.headers, httpResponse2.headers)) {
                return true;
            }
        }
        return false;
    }
}

