/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.plugin;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.log.SRPlatformLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlatformInit;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRProxyAdapter;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.update.UpdateCheckInit;
import net.skinsrestorer.shared.utils.SRHelpers;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={PlatformClass.class})
public class SRBootstrapper {
    public static void startPlugin(Consumer<Runnable> shutdownHookConsumer, List<PlatformClass<?>> platformRegister, SRPlatformLogger isrLogger, boolean loggerColor, Class<? extends SRPlatformAdapter> adapterClass, Class<?> srPlatformClass, Path dataFolder, Class<? extends SRPlatformInit> initClass) {
        SRPlugin srPlugin;
        block8: {
            srPlugin = null;
            try {
                Injector injector = SRHelpers.createInjector();
                platformRegister.forEach(pc -> pc.accept(injector));
                injector.register(SRLogger.class, new SRLogger(isrLogger, loggerColor));
                SRPlatformAdapter adapter = injector.getSingleton(adapterClass);
                injector.register(SRPlatformAdapter.class, adapter);
                if (adapter instanceof SRServerAdapter) {
                    SRServerAdapter serverAdapter = (SRServerAdapter)adapter;
                    injector.register(SRServerAdapter.class, serverAdapter);
                } else if (adapter instanceof SRProxyAdapter) {
                    SRProxyAdapter proxyAdapter = (SRProxyAdapter)adapter;
                    injector.register(SRProxyAdapter.class, proxyAdapter);
                }
                srPlugin = new SRPlugin(injector, dataFolder);
                injector.getSingleton(srPlatformClass);
                shutdownHookConsumer.accept(srPlugin::shutdown);
                srPlugin.startup(initClass);
            }
            catch (Throwable t) {
                isrLogger.log(SRLogLevel.SEVERE, "An unexpected error occurred while starting the plugin. Please check the console for more details.", t);
                if (!SRPlugin.isUnitTest()) break block8;
                throw new AssertionError((Object)t);
            }
        }
        if (srPlugin != null && !srPlugin.isUpdaterInitialized()) {
            isrLogger.log(SRLogLevel.WARNING, "Updater was not initialized, a error occurred while starting the plugin. Forcing updater to initialize.");
            try {
                srPlugin.initUpdateCheck(UpdateCheckInit.InitCause.ERROR);
            }
            catch (Throwable t) {
                isrLogger.log(SRLogLevel.SEVERE, "An unexpected error occurred while initializing the updater. Please check the console for more details.", t);
            }
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="clazz", type=Class.class), @RecordComponents.Value(name="value", type=Object.class)})
    @NestHost(value=SRBootstrapper.class)
    public static final class PlatformClass<V>
    extends J_L_Record {
        private final Class<V> clazz;
        private final V value;

        public PlatformClass(Class<V> clazz, V value) {
            this.clazz = clazz;
            this.value = value;
        }

        public void accept(Injector injector) {
            injector.register(this.clazz, this.value);
        }

        @Override
        public final String toString() {
            return PlatformClass.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return PlatformClass.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return PlatformClass.jvmdowngrader$equals$equals(this, o);
        }

        public Class<V> clazz() {
            return this.clazz;
        }

        public V value() {
            return this.value;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(PlatformClass platformClass) {
            PlatformClass platformClass2 = platformClass;
            return "SRBootstrapper$PlatformClass[" + "clazz=" + platformClass.clazz + ", " + "value=" + platformClass.value + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(PlatformClass platformClass) {
            Object[] objectArray = new Object[]{platformClass.clazz, platformClass.value};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(PlatformClass platformClass, Object object) {
            if (platformClass == object) {
                return true;
            }
            if (object != null && object instanceof PlatformClass) {
                PlatformClass platformClass2 = (PlatformClass)object;
                if (Objects.equals(platformClass.clazz, platformClass2.clazz) && Objects.equals(platformClass.value, platformClass2.value)) {
                    return true;
                }
            }
            return false;
        }
    }
}

