/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.plugin;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.connections.MineSkinAPI;
import net.skinsrestorer.api.connections.MojangAPI;
import net.skinsrestorer.api.property.SkinApplier;
import net.skinsrestorer.api.storage.CacheStorage;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.api.storage.SkinStorage;
import net.skinsrestorer.builddata.BuildData;
import net.skinsrestorer.shadow.bstats.MetricsBase;
import net.skinsrestorer.shadow.bstats.charts.AdvancedPie;
import net.skinsrestorer.shadow.bstats.charts.DrilldownPie;
import net.skinsrestorer.shadow.bstats.charts.SimplePie;
import net.skinsrestorer.shadow.bstats.charts.SingleLineChart;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.configme.SettingsManagerBuilder;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j18.stub.java_base.J_L_System;
import net.skinsrestorer.shared.api.SharedSkinApplier;
import net.skinsrestorer.shared.api.SharedSkinsRestorer;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.commands.GUICommand;
import net.skinsrestorer.shared.commands.SRCommand;
import net.skinsrestorer.shared.commands.SkinCommand;
import net.skinsrestorer.shared.commands.SkullCommand;
import net.skinsrestorer.shared.commands.library.SRCommandManager;
import net.skinsrestorer.shared.config.APIConfig;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.config.CommentsConfig;
import net.skinsrestorer.shared.config.ConfigMigratorService;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.config.DevConfig;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.config.LoginConfig;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.config.ProxyConfig;
import net.skinsrestorer.shared.config.ServerConfig;
import net.skinsrestorer.shared.config.StorageConfig;
import net.skinsrestorer.shared.connections.MineSkinAPIImpl;
import net.skinsrestorer.shared.connections.MojangAPIImpl;
import net.skinsrestorer.shared.connections.RecommendationsState;
import net.skinsrestorer.shared.connections.ServiceCheckerService;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.floodgate.FloodgateUtil;
import net.skinsrestorer.shared.log.SRChatColor;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlatformInit;
import net.skinsrestorer.shared.plugin.SRProxyPlatformInit;
import net.skinsrestorer.shared.plugin.SRProxyPlugin;
import net.skinsrestorer.shared.plugin.SRServerPlatformInit;
import net.skinsrestorer.shared.plugin.SRServerPlugin;
import net.skinsrestorer.shared.storage.CacheStorageImpl;
import net.skinsrestorer.shared.storage.PlayerStorageImpl;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.storage.adapter.AdapterReference;
import net.skinsrestorer.shared.storage.adapter.file.FileAdapter;
import net.skinsrestorer.shared.storage.adapter.mysql.MySQLAdapter;
import net.skinsrestorer.shared.storage.adapter.mysql.MySQLProvider;
import net.skinsrestorer.shared.subjects.SRSubjectWrapper;
import net.skinsrestorer.shared.subjects.messages.MessageLoader;
import net.skinsrestorer.shared.update.UpdateCheckInit;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import net.skinsrestorer.shared.utils.SRHelpers;

public class SRPlugin {
    private static final boolean unitTest = J_L_System.getProperty("sr.unit.test") != null;
    private static final String LOADED_PROPERTY = "sr.jvm.loaded";
    private final SRPlatformAdapter adapter;
    private final SRLogger logger;
    private final Path dataFolder;
    private final Injector injector;
    private final List<Runnable> shutdownHooks = new ArrayList<Runnable>();
    private boolean outdated = false;
    private boolean updaterInitialized = false;

    public SRPlugin(Injector injector, Path dataFolder) {
        injector.register(SRPlugin.class, this);
        this.injector = injector;
        this.adapter = injector.getSingleton(SRPlatformAdapter.class);
        this.logger = injector.getSingleton(SRLogger.class);
        this.dataFolder = dataFolder;
    }

    public SRPlatformAdapter getAdapter() {
        return this.adapter;
    }

    public void initCommands() {
        SRCommandManager manager = this.injector.getSingleton(SRCommandManager.class);
        manager.registerCommand(this.injector.newInstance(SRCommand.class));
        SettingsManager settings = this.injector.getSingleton(SettingsManager.class);
        if (!settings.getProperty(CommandConfig.DISABLE_SKIN_COMMAND).booleanValue()) {
            manager.registerCommand(this.injector.newInstance(SkinCommand.class));
        }
        if (!settings.getProperty(CommandConfig.DISABLE_SKULL_COMMAND).booleanValue()) {
            manager.registerCommand(this.injector.newInstance(SkullCommand.class));
        }
        if (!settings.getProperty(CommandConfig.DISABLE_GUI_COMMAND).booleanValue()) {
            manager.registerCommand(this.injector.newInstance(GUICommand.class));
        }
    }

    public void loadConfig() {
        SettingsManager settings = this.injector.getIfAvailable(SettingsManager.class);
        if (settings == null) {
            settings = SettingsManagerBuilder.withYamlFile(this.dataFolder.resolve("config.yml")).configurationData(CommentsConfig.class, MessageConfig.class, DatabaseConfig.class, CommandConfig.class, GUIConfig.class, StorageConfig.class, ProxyConfig.class, ServerConfig.class, LoginConfig.class, APIConfig.class, AdvancedConfig.class, DevConfig.class).migrationService(this.injector.getSingleton(ConfigMigratorService.class)).create();
            this.injector.register(SettingsManager.class, settings);
        } else {
            settings.reload();
        }
        this.logger.setDebug(settings.getProperty(DevConfig.DEBUG) != false || unitTest);
        this.revertSettings(settings);
    }

    private void revertSettings(SettingsManager settings) {
        if (settings.getProperty(StorageConfig.DEFAULT_SKINS_ENABLED).booleanValue() && settings.getProperty(StorageConfig.DEFAULT_SKINS).isEmpty()) {
            this.logger.warning("[Config] No DefaultSkins configured! Disabling DefaultSkins.");
            settings.setProperty(StorageConfig.DEFAULT_SKINS_ENABLED, false);
        }
        if (settings.getProperty(CommandConfig.DISABLED_SKINS_ENABLED).booleanValue() && settings.getProperty(CommandConfig.DISABLED_SKINS).isEmpty()) {
            this.logger.warning("[Config] No DisabledSkins configured! Disabling DisabledSkins.");
            settings.setProperty(CommandConfig.DISABLED_SKINS_ENABLED, false);
        }
        if (settings.getProperty(CommandConfig.RESTRICT_SKIN_URLS_ENABLED).booleanValue() && settings.getProperty(CommandConfig.RESTRICT_SKIN_URLS_LIST).isEmpty()) {
            this.logger.warning("[Config] No RestrictSkinUrls configured! Disabling RestrictSkinUrls.");
            settings.setProperty(CommandConfig.RESTRICT_SKIN_URLS_ENABLED, false);
        }
        if (settings.getProperty(CommandConfig.FORCE_DEFAULT_PERMISSIONS).booleanValue()) {
            if (this.adapter.supportsDefaultPermissions()) {
                this.logger.debug("Disabling enforcing default permissions");
                settings.setProperty(CommandConfig.FORCE_DEFAULT_PERMISSIONS, false);
            } else {
                this.logger.info("Enforcing default permissions plugin-side due to platform limitations.");
            }
        }
        if (settings.getProperty(CommandConfig.PER_SKIN_PERMISSIONS).booleanValue() && !settings.getProperty(CommandConfig.PER_SKIN_PERMISSIONS_CONSENT).equalsIgnoreCase("I will follow the rules")) {
            this.logger.warning(J_L_String.formatted("You must agree to the rules at '%s' in the config to use per skin permissions.", CommandConfig.PER_SKIN_PERMISSIONS_CONSENT.getPath()));
        }
        if (!settings.getProperty(ServerConfig.DISMOUNT_PLAYER_ON_UPDATE).booleanValue()) {
            settings.setProperty(ServerConfig.REMOUNT_PLAYER_ON_UPDATE, false);
        }
    }

    public void loadLocales() throws IOException {
        this.injector.getSingleton(MessageLoader.class).loadMessages();
    }

    public void moveOldFiles() {
        try {
            SRHelpers.renameFile(this.dataFolder, "Archive", "archive");
        }
        catch (IOException e) {
            this.logger.warning("Failed to rename Archive folder to lowercase.", e);
        }
        this.moveToArchive(this.dataFolder.resolve("messages.yml"));
        this.moveToArchive(this.dataFolder.resolve("command-messages.properties"));
        this.moveToArchive(this.dataFolder.resolve("command.properties"));
        this.moveToArchive(this.dataFolder.resolve("languages"));
    }

    public void moveToArchive(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        this.logger.info(J_L_String.formatted("Moving old file %s to archive folder.", path.getFileName()));
        Path archive = this.dataFolder.resolve("archive");
        Path target = archive.resolve(SRPlugin.jvmdowngrader$concat$moveToArchive$1(path.getFileName().toString(), SRHelpers.getEpochSecond()));
        try {
            SRHelpers.createDirectoriesSafe(archive);
            Files.move(path, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.logger.warning(J_L_String.formatted("Failed to move old file %s to archive folder.", path.getFileName()), e);
        }
    }

    public void loadStorage() throws InitializeException {
        SkinStorageImpl skinStorage = this.injector.getSingleton(SkinStorageImpl.class);
        SettingsManager settings = this.injector.getSingleton(SettingsManager.class);
        try {
            if (settings.getProperty(DatabaseConfig.MYSQL_ENABLED).booleanValue()) {
                MySQLProvider mySQLProvider = this.injector.getSingleton(MySQLProvider.class);
                mySQLProvider.initPool();
                MySQLAdapter adapter = this.injector.getSingleton(MySQLAdapter.class);
                adapter.init();
                this.logger.info("Connected to MySQL!");
                this.injector.getSingleton(AdapterReference.class).setAdapter(adapter);
            } else {
                this.injector.getSingleton(AdapterReference.class).setAdapter(this.injector.getSingleton(FileAdapter.class));
            }
            this.adapter.runAsync(skinStorage::preloadDefaultSkins);
        }
        catch (SQLException e) {
            this.logger.severe("\u00a7cCan't connect to MySQL! Disabling SkinsRestorer.", e);
            throw new InitializeException(e);
        }
    }

    public void initUpdateCheck(UpdateCheckInit.InitCause cause) {
        if (this.updaterInitialized) {
            return;
        }
        this.updaterInitialized = true;
        this.injector.getSingleton(UpdateCheckInit.class).run(cause);
    }

    public void setOutdated() {
        this.outdated = true;
    }

    public void registerAPI() {
        SkinsRestorer api = this.injector.getSingleton(SharedSkinsRestorer.class);
        SkinsRestorerProvider.setApi(api);
        this.injector.register(SkinsRestorer.class, api);
    }

    public <P> void registerSkinApplier(SkinApplierAccess<P> skinApplier, Class<P> playerClass, SRSubjectWrapper<?, P, ?> platformWrapper) {
        SharedSkinApplier<P> sharedSkinApplier = new SharedSkinApplier<P>(playerClass, skinApplier, platformWrapper, this.injector.getSingleton(PlayerStorageImpl.class), this.injector.getSingleton(SkinStorageImpl.class), this.injector.getSingleton(this.adapter.getSoundProviderClass()));
        this.injector.register(SharedSkinApplier.class, sharedSkinApplier);
        this.injector.register(SkinApplier.class, sharedSkinApplier);
    }

    public void registerMetrics(Object metricsParent) {
        MetricsBase metrics;
        if (metricsParent == null) {
            return;
        }
        try {
            Field field = metricsParent.getClass().getDeclaredField("metricsBase");
            field.setAccessible(true);
            metrics = (MetricsBase)field.get(metricsParent);
        }
        catch (ReflectiveOperationException e) {
            this.logger.warning("Failed to register metrics", e);
            return;
        }
        MetricsCounter metricsCounter = this.injector.getSingleton(MetricsCounter.class);
        metrics.addCustomChart(new SimplePie("uses_mysql", metricsCounter::usesMySQL));
        metrics.addCustomChart(new SimplePie("proxy_mode", metricsCounter::isProxyMode));
        metrics.addCustomChart(new DrilldownPie("plugin_config", metricsCounter::pluginConfig));
        metrics.addCustomChart(new AdvancedPie("skin_command", metricsCounter::skinCommand));
        for (MetricsCounter.Service service : MetricsCounter.Service.values()) {
            metrics.addCustomChart(new SingleLineChart(service.name().toLowerCase(Locale.ROOT), () -> metricsCounter.collect(service)));
        }
    }

    public void startup(Class<? extends SRPlatformInit> initClass) throws Exception {
        if (Boolean.getBoolean(LOADED_PROPERTY)) {
            this.logger.severe("SkinsRestorer was already loaded in this JVM. You must've used a plugin like PlugMan to reload it. This is not supported and will cause issues with the plugin! Please restart your server to reload the plugin properly.");
        } else {
            System.setProperty(LOADED_PROPERTY, "true");
        }
        SRServerPlugin serverPlugin = this.injector.getIfAvailable(SRServerPlugin.class);
        SRProxyPlugin proxyPlugin = this.injector.getIfAvailable(SRProxyPlugin.class);
        this.loadConfig();
        if (!unitTest) {
            this.registerMetrics(this.adapter.createMetricsInstance());
        }
        this.injector.getSingleton(EventBusImpl.class);
        if (serverPlugin != null) {
            serverPlugin.checkProxyMode();
        }
        this.moveOldFiles();
        this.loadLocales();
        this.injector.register(MineSkinAPI.class, this.injector.getSingleton(MineSkinAPIImpl.class));
        this.injector.register(MojangAPI.class, this.injector.getSingleton(MojangAPIImpl.class));
        this.injector.register(CacheStorage.class, this.injector.getSingleton(CacheStorageImpl.class));
        this.injector.register(SkinStorage.class, this.injector.getSingleton(SkinStorageImpl.class));
        this.injector.register(PlayerStorage.class, this.injector.getSingleton(PlayerStorageImpl.class));
        SRPlatformInit platformInit = this.injector.newInstance(initClass);
        platformInit.checkPluginSupport();
        platformInit.initSkinApplier();
        platformInit.prePlatformInit();
        if (serverPlugin != null) {
            serverPlugin.startupPlatform((SRServerPlatformInit)platformInit);
        } else if (proxyPlugin != null) {
            proxyPlugin.startupPlatform((SRProxyPlatformInit)platformInit);
        } else {
            throw new IllegalStateException("No platform class available!");
        }
        this.injector.getSingleton(RecommendationsState.class).scheduleRecommendations();
        this.runJavaCheck();
        this.initUpdateCheck(UpdateCheckInit.InitCause.STARTUP);
        if (serverPlugin == null || !serverPlugin.isProxyMode()) {
            this.adapter.runAsync(this::runServiceCheck);
        }
    }

    public void registerFloodgate() {
        if (ReflectionUtil.classExists("org.geysermc.floodgate.api.FloodgateApi")) {
            FloodgateUtil.registerListener(this.injector);
        }
    }

    private void runJavaCheck() {
        try {
            int version = SRHelpers.getJavaVersion();
            if (version < 17) {
                this.logger.warning(SRPlugin.jvmdowngrader$concat$runJavaCheck$1(String.valueOf((Object)SRChatColor.YELLOW), J_L_String.formatted("You are running an outdated Java version, please update it to at least Java 21 (your version is %d).", version)));
                this.logger.warning(SRPlugin.jvmdowngrader$concat$runJavaCheck$1(String.valueOf((Object)SRChatColor.YELLOW)));
                this.logger.warning(SRPlugin.jvmdowngrader$concat$runJavaCheck$2(String.valueOf((Object)SRChatColor.YELLOW)));
            } else if (version < 21) {
                this.logger.warning(SRPlugin.jvmdowngrader$concat$runJavaCheck$1(String.valueOf((Object)SRChatColor.YELLOW), J_L_String.formatted("Please update your Java runtime to at least Java 21 (your version is %d).", version)));
                this.logger.warning(SRPlugin.jvmdowngrader$concat$runJavaCheck$3(String.valueOf((Object)SRChatColor.YELLOW)));
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to parse Java version.", e);
        }
    }

    private void runServiceCheck() {
        ServiceCheckerService.ServiceCheckResponse response = this.injector.getSingleton(ServiceCheckerService.class).checkServices();
        if (response.minOneServiceUnavailable()) {
            this.logger.info("\u00a7c[\u00a74Critical\u00a7c] ------------------[\u00a72SkinsRestorer \u00a7cis \u00a7c\u00a7l\u00a7nOFFLINE\u00a7r\u00a7c] -------------------------");
            this.logger.info("\u00a7c[\u00a74Critical\u00a7c] \u00a7cPlugin currently can't fetch new skins due to blocked connection!");
            this.logger.info("\u00a7c[\u00a74Critical\u00a7c] \u00a7cSee https://skinsrestorer.net/firewall for steps to resolve your issue!");
            this.logger.info("\u00a7c[\u00a74Critical\u00a7c] ----------------------------------------------------------------------");
        }
    }

    public String getUserAgent() {
        return J_L_String.formatted("SkinsRestorer/%s (%s)", new Object[]{BuildData.VERSION, this.adapter.getPlatform()});
    }

    public void shutdown() {
        this.adapter.shutdownCleanup();
        this.shutdownHooks.forEach(Runnable::run);
    }

    @Generated
    public static boolean isUnitTest() {
        return unitTest;
    }

    @Generated
    public Path getDataFolder() {
        return this.dataFolder;
    }

    @Generated
    public List<Runnable> getShutdownHooks() {
        return this.shutdownHooks;
    }

    @Generated
    public boolean isOutdated() {
        return this.outdated;
    }

    @Generated
    public boolean isUpdaterInitialized() {
        return this.updaterInitialized;
    }

    private static /* synthetic */ String jvmdowngrader$concat$moveToArchive$1(String string, long l) {
        return string + "_" + l;
    }

    private static /* synthetic */ String jvmdowngrader$concat$runJavaCheck$1(String string, String string2) {
        return string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$runJavaCheck$1(String string) {
        return string + "SkinsRestorer no longer officially supports this version of Java, you are currently using an unsupported compatibility build.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$runJavaCheck$2(String string) {
        return string + "You can still use the plugin, but you may encounter issues that are not present in newer versions of Java.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$runJavaCheck$3(String string) {
        return string + "At some point in the future, SkinsRestorer will no longer be compatible with this version of Java.";
    }
}

