/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import lombok.Generated;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.config.ServerConfig;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.plugin.SRServerPlatformInit;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class SRServerPlugin {
    private final SRPlugin plugin;
    private final SRServerAdapter serverAdapter;
    private final SRLogger logger;
    private final Injector injector;
    private boolean proxyMode;

    public void checkProxyMode() {
        this.proxyMode = this.checkProxy();
        try {
            Files.deleteIfExists(this.plugin.getDataFolder().resolve("(README) Use proxy config for settings! (README).txt"));
        }
        catch (IOException e) {
            this.logger.severe("Failed to create proxy warning file", e);
        }
        if (this.proxyMode) {
            this.logger.info("-------------------------/Warning\\-------------------------");
            this.logger.info("This plugin is running in PROXY mode!");
            this.logger.info("You have to put the same config.yml on all servers and on the proxy.");
            this.logger.info("(<proxy>/plugins/SkinsRestorer/)");
            this.logger.info("-------------------------\\Warning/-------------------------");
        }
    }

    private boolean checkProxy() {
        boolean bl;
        SettingsManager settingsManager = this.injector.getSingleton(SettingsManager.class);
        ServerConfig.ProxyMode proxyModeDetection = settingsManager.getProperty(ServerConfig.PROXY_MODE_DETECTION);
        switch (proxyModeDetection) {
            default: {
                throw new J_L_MatchException(null, null);
            }
            case ENABLED: {
                bl = true;
                break;
            }
            case DISABLED: {
                bl = false;
                break;
            }
            case AUTO: {
                Path proxyModeEnabled = this.plugin.getDataFolder().resolve("enableProxyMode.txt");
                Path proxyModeDisabled = this.plugin.getDataFolder().resolve("disableProxyMode.txt");
                if (Files.exists(proxyModeEnabled, new LinkOption[0])) {
                    this.logger.warning("Proxy mode files are deprecated, please use the config file instead.");
                    bl = true;
                    break;
                }
                if (Files.exists(proxyModeDisabled, new LinkOption[0])) {
                    this.logger.warning("Proxy mode files are deprecated, please use the config file instead.");
                    bl = false;
                    break;
                }
                bl = this.serverAdapter.determineProxy();
                break;
            }
        }
        return bl;
    }

    public void startupPlatform(SRServerPlatformInit init) throws InitializeException {
        init.initMetricsJoinListener();
        init.initPermissions();
        init.initGUIListener();
        init.initAdminInfoListener();
        if (this.proxyMode) {
            boolean proxyModeApiFile = Files.exists(this.plugin.getDataFolder().resolve("enableSkinStorageAPI.txt"), new LinkOption[0]);
            if (proxyModeApiFile) {
                this.logger.warning("Proxy mode API files are deprecated, please use the config file instead.");
            }
            SettingsManager settingsManager = this.injector.getSingleton(SettingsManager.class);
            if (proxyModeApiFile || settingsManager.getProperty(ServerConfig.PROXY_MODE_API).booleanValue()) {
                if (settingsManager.getProperty(DatabaseConfig.MYSQL_ENABLED).booleanValue()) {
                    this.plugin.loadStorage();
                    this.plugin.registerAPI();
                    this.plugin.registerFloodgate();
                } else {
                    this.logger.warning("Proxy mode API is enabled (server.proxyMode.api), but MySQL is not set up, this is not supported. You must configure MySQL on all servers and on the proxy and use the same database.");
                }
            }
            init.initMessageChannel();
        } else {
            this.plugin.loadStorage();
            this.plugin.registerAPI();
            this.plugin.registerFloodgate();
            this.plugin.initCommands();
            init.initLoginProfileListener();
        }
        init.placeholderSetupHook();
    }

    @Inject
    @Generated
    public SRServerPlugin(SRPlugin plugin, SRServerAdapter serverAdapter, SRLogger logger, Injector injector) {
        this.plugin = plugin;
        this.serverAdapter = serverAdapter;
        this.logger = logger;
        this.injector = injector;
    }

    @Generated
    public boolean isProxyMode() {
        return this.proxyMode;
    }

    @Generated
    public void setProxyMode(boolean proxyMode) {
        this.proxyMode = proxyMode;
    }
}

