/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.update;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.semver.SemanticVersion;
import net.skinsrestorer.builddata.BuildData;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.connections.http.HttpClient;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.exception.DataRequestExceptionShared;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerPlugin;
import net.skinsrestorer.shared.update.UpdateCause;
import net.skinsrestorer.shared.update.UpdateDownloader;
import net.skinsrestorer.shared.update.model.GitHubAssetInfo;
import net.skinsrestorer.shared.update.model.GitHubReleaseInfo;

public class UpdateCheckerGitHub {
    private static final URI RELEASES_URL_LATEST = URI.create("https://api.github.com/repos/SkinsRestorer/SkinsRestorer/releases/latest");
    private static final String JAR_ASSET_NAME = "SkinsRestorer.jar";
    private static final String LOG_ROW = "\u00a7a----------------------------------------------";
    private final SRLogger logger;
    private final SRPlugin plugin;
    private final Injector injector;
    private final HttpClient httpClient;
    private boolean updateDownloaded;
    private boolean hasPrintedUpdateAvailableBanner;

    private static String getCheckerPluginVersion() {
        if (SRPlugin.isUnitTest()) {
            return System.getProperty("sr.check.version", BuildData.VERSION);
        }
        return BuildData.VERSION;
    }

    public void checkForUpdate(UpdateCause cause, UpdateDownloader downloader) {
        try {
            HttpResponse response = this.httpClient.execute(RELEASES_URL_LATEST, null, HttpClient.HttpType.JSON, this.plugin.getUserAgent(), HttpClient.HttpMethod.GET, Collections.emptyMap(), 90000);
            GitHubReleaseInfo releaseInfo = response.getBodyAs(GitHubReleaseInfo.class);
            if (releaseInfo.getAssets() == null || releaseInfo.getAssets().isEmpty()) {
                throw new DataRequestExceptionShared("No release info found");
            }
            Optional<GitHubAssetInfo> jarAssetUrl = releaseInfo.getAssets().stream().filter(asset -> asset.getName().equals(JAR_ASSET_NAME)).findFirst();
            if (J_U_Optional.isEmpty(jarAssetUrl)) {
                throw new DataRequestExceptionShared("No jar asset found in release");
            }
            if (this.isVersionNewer(UpdateCheckerGitHub.getCheckerPluginVersion(), releaseInfo.getTagName())) {
                this.plugin.setOutdated();
                if (this.updateDownloaded) {
                    return;
                }
                this.printUpdateAvailable(cause, releaseInfo.getTagName(), downloader != null);
                if (downloader != null && downloader.downloadUpdate(jarAssetUrl.get())) {
                    this.updateDownloaded = true;
                }
            } else {
                if (cause == UpdateCause.SCHEDULED) {
                    return;
                }
                this.printUpToDate(cause);
            }
        }
        catch (IOException | DataRequestException e) {
            this.logger.warning("Failed to get release info from api.github.com. \n If this message is repeated a lot, please see https://skinsrestorer.net/firewall");
            this.logger.debug(e);
        }
    }

    public void printUpToDate(UpdateCause cause) {
        this.printHeader(cause);
        this.logger.info(J_L_String.formatted("\u00a7b    Version: \u00a7a%s", BuildData.VERSION));
        this.logger.info(J_L_String.formatted("\u00a7b    Commit: \u00a7a%s", BuildData.COMMIT_SHORT));
        if (cause == UpdateCause.NETWORK_DISABLED) {
            this.logger.info("\u00a7c    Network connections are disabled in the SkinsRestorer config (advanced.noConnections), we will not check for updates.");
        } else if (Files.exists(this.plugin.getDataFolder().resolve("noupdate.txt"), new LinkOption[0])) {
            this.logger.info("\u00a7e    The updater is disabled using noupdate.txt");
        } else {
            this.logger.info("\u00a7a    This is the latest version!");
        }
        this.printFooter();
    }

    public void printUpdateAvailable(UpdateCause cause, String newVersion, boolean updateDownloader) {
        if (this.hasPrintedUpdateAvailableBanner) {
            this.logger.info(J_L_String.formatted("\u00a7bA new version of SkinsRestorer (\u00a7a%s\u00a7b) is available: \u00a7a%s/version/%s", newVersion, "https://modrinth.com/plugin/skinsrestorer", newVersion));
        } else {
            this.hasPrintedUpdateAvailableBanner = true;
            this.printHeader(cause);
            this.logger.info(J_L_String.formatted("\u00a7b    Version: \u00a7c%s", BuildData.VERSION));
            this.logger.info(J_L_String.formatted("\u00a7b    Commit: \u00a7c%s", BuildData.COMMIT_SHORT));
            if (updateDownloader) {
                this.logger.info(J_L_String.formatted("\u00a7b    A new version (\u00a7a%s\u00a7b) is available! Downloading update...", newVersion));
            } else {
                this.logger.info(J_L_String.formatted("\u00a7b    A new version (\u00a7a%s\u00a7b) is available!", newVersion));
                this.logger.info(J_L_String.formatted("\u00a7e    %s/version/%s", "https://modrinth.com/plugin/skinsrestorer", newVersion));
            }
            this.printFooter();
        }
    }

    private void printHeader(UpdateCause cause) {
        this.logger.info(LOG_ROW);
        this.logger.info("\u00a7a    +==================+");
        this.logger.info("\u00a7a    |   SkinsRestorer  |");
        this.logger.info("\u00a7a    |------------------|");
        if (cause.isError()) {
            this.logger.info("\u00a7a    |    \u00a7cError Mode\u00a7a    |");
        } else {
            SRServerPlugin serverPlugin = this.injector.getIfAvailable(SRServerPlugin.class);
            if (serverPlugin != null) {
                if (serverPlugin.isProxyMode()) {
                    this.logger.info("\u00a7a    |    \u00a7eProxy Mode\u00a7a    |");
                } else {
                    this.logger.info("\u00a7a    |  \u00a79\u00a7n\u00a7lStandalone Mode\u00a7r\u00a7a |");
                }
            }
        }
        this.logger.info("\u00a7a    +==================+");
        this.logger.info(LOG_ROW);
    }

    private void printFooter() {
        this.logger.info(LOG_ROW);
        this.logger.info("\u00a79Do you have issues? Read our troubleshooting guide: \u00a7ehttps://skinsrestorer.net/docs/troubleshooting");
        this.logger.info("\u00a79Want to support SkinsRestorer? Consider donating: \u00a7ehttps://skinsrestorer.net/donate");
    }

    public boolean isVersionNewer(String currentVersion, String newVersion) {
        return SemanticVersion.fromString(newVersion).isNewerThan(SemanticVersion.fromString(currentVersion));
    }

    @Inject
    @Generated
    public UpdateCheckerGitHub(SRLogger logger, SRPlugin plugin, Injector injector, HttpClient httpClient) {
        this.logger = logger;
        this.plugin = plugin;
        this.injector = injector;
        this.httpClient = httpClient;
    }
}

