package dev.zenfyr.andromeda.common.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.bootstrap.config.RegisterConfigEvent;
import dev.zenfyr.andromeda.bootstrap.event.InitEvents;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.config.handler.MultiConfigHandler;
import dev.zenfyr.pulsar.creativetab.CreativeModeTabAnimaton;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

public class AndromedaClient implements ClientModInitializer {

  private static AndromedaClient instance;

  public static final MultiConfigHandler CLIENT = new MultiConfigHandler(
      ModuleManager.get(),
      FabricLoader.getInstance().getConfigDir(),
      "client",
      RegisterConfigEvent.CLIENT);
  private static final class_2960 BACKGROUND_TEXTURE =
      Andromeda.id("textures/gui/background.png");
  private static final class_2960 GALAXY_TEXTURE = Andromeda.id("textures/gui/galaxy.png");

  @Override
  public void onInitializeClient() {
    Andromeda.get().onMergedEntryPoint();
    instance = this;

    var manager = ModuleManager.get();

    CLIENT.loadAll();
    CLIENT.saveAll();

    InitEvents.CLIENT.invoker().onModuleClientInit().runEntrypoint();

    if (Andromeda.GROUP.isPresent()) {
      CreativeModeTabAnimaton.setIconAnimation(
          Andromeda.GROUP.orThrow(), (tab, graphics, x, y, selected, isTopRow) -> {
            drawTexture(graphics.method_51448(), x + 8, y + 8, stack -> {}, BACKGROUND_TEXTURE);
            drawTexture(
                graphics.method_51448(),
                x + 8,
                y + 8,
                stack -> stack.method_22907(class_7833.field_40717.rotationDegrees(class_156.method_658() * 0.05f)),
                GALAXY_TEXTURE);
          });
    }
  }

  public static AndromedaClient get() {
    return instance;
  }

  public static void drawTexture(
      class_4587 matrices, int x, int y, Consumer<class_4587> transform, class_2960 location) {
    RenderSystem.setShaderTexture(0, location);
    RenderSystem.setShader(class_757::method_34542);

    matrices.method_22903();
    matrices.method_46416(x, y, 100);
    matrices.method_22905(1, 1, 1);
    transform.accept(matrices);

    Matrix4f matrix4f = matrices.method_23760().method_23761();
    class_287 bufferBuilder = class_289.method_1348().method_1349();
    bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);

    bufferBuilder.method_22918(matrix4f, -8, 8, 0).method_22913(0, 1).method_1344();
    bufferBuilder.method_22918(matrix4f, 8, 8, 0).method_22913(1, 1).method_1344();
    bufferBuilder.method_22918(matrix4f, 8, -8, 0).method_22913(1, 0).method_1344();
    bufferBuilder.method_22918(matrix4f, -8, -8, 0).method_22913(0, 0).method_1344();

    RenderSystem.enableBlend();
    class_286.method_43433(bufferBuilder.method_1326());
    RenderSystem.disableBlend();
    matrices.method_22909();
  }
}
