package dev.zenfyr.andromeda.common.client.config;

import dev.zenfyr.andromeda.bootstrap.Module;
import dev.zenfyr.andromeda.bootstrap.ModuleHelper;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.client.AndromedaClient;
import dev.zenfyr.andromeda.common.config.handler.MultiConfigHandler;
import dev.zenfyr.andromeda.common.mixin.MultiElementListEntryAccessor;
import dev.zenfyr.pulsar.util.TextUtil;
import java.lang.reflect.Field;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoConfigScreen {
  public static final class_2561 RESET_BUTTON_KEY = class_2561.method_43471("text.cloth-config.reset_value");
  private final ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
  private final IdentityHashMap<Class<?>, Entry<?>> providers = new IdentityHashMap<>();
  private final Map<@NotNull MultiConfigHandler, @NotNull String> handlers;
  private final Entry<Object> objectEntry;
  private final Entry<Enum<?>> enumEntry;

  public AutoConfigScreen() {
    EntryProviders.init(this);
    this.handlers = Map.of(Andromeda.MAIN, "main", Andromeda.GAME, "game", AndromedaClient.CLIENT, "client");
    this.objectEntry = (Entry<Object>) this.providers.get(Object.class);
    this.enumEntry = (Entry<Enum<?>>) this.providers.get(Enum.class);
  }

  public ConfigEntryBuilder entryBuilder() {
    return this.entryBuilder;
  }

  public <T> void register(Class<T> type, EntryFunction<T> entryFunction, Function<Class<?>, T> def) {
    providers.put(type, new Entry<>(context -> {
      var entry = entryFunction.getEntry(context);
      if (context.field() != null) {
        if (context.field().isAnnotationPresent(ConfigEntry.Gui.RequiresRestart.class)) entry.setRequiresRestart(true);
      }
      if (context.module() != null) {
        ClothTooltipUtil.setEntryTooltip(entry, context.i18n() + ".@Tooltip");
      }
      return ClothTooltipUtil.wrapTooltip(entry);
    }, def));
  }

  public <T> Entry<T> getEntry(Class<T> type) {
    var e = (Entry<T>) providers.get(type);
    if (e != null) return e;
    if (type.isEnum() || Enum.class.isAssignableFrom(type)) {
      return (Entry<T>) this.enumEntry;
    }
    return (Entry<T>) this.objectEntry;
  }

  public class_437 getScreen(class_437 parent) {
    Map<Object, Runnable> saveQueue = new IdentityHashMap<>();
    ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(TextUtil.translatable("config.andromeda.title", "67")).setSavingRunnable(() -> {
      saveQueue.values().forEach(Runnable::run);
      saveQueue.clear();
    }).setDefaultBackgroundTexture(class_2960.method_43902("minecraft", "textures/block/amethyst_block.png"));
    var bootstrapHandler = ModuleManager.get().configHandler();
    for (Module module : ModuleManager.get().all().stream().sorted(Comparator.comparing(ModuleHelper::id)).toList()) {
      var category = builder.getOrCreateCategory(TextUtil.translatable("config.andromeda.category.%s".formatted(module.meta().category())));
      String moduleText = "config.andromeda.%s".formatted(ModuleHelper.dotted(module.meta()));
      var moduleCategory = this.entryBuilder().startSubCategory(TextUtil.translatable(moduleText));
      this.handlers.forEach((handler, state) -> {
        var definition = handler.getDefinition(module);
        if (definition == null) return;
        var stateKey = "config.andromeda.state.%s".formatted(state);
        var stateCategory = this.entryBuilder().startSubCategory(TextUtil.translatable(stateKey));
        var config = handler.get(definition);
        var defConfig = handler.getDefault(definition);
        var e = this.objectEntry.function().getEntry(makeRootCtx(config, defConfig, o -> saveQueue.put(definition, () -> handler.save(module)), moduleText, module));
        stateCategory.addAll(((MultiElementListEntryAccessor) e).pulsar$entries());
        if (!stateCategory.isEmpty()) moduleCategory.add(stateCategory.build());
      });
      var rootI18n = moduleCategory.isEmpty() ? TextUtil.translatable(moduleText) : TextUtil.translatable("config.andromeda.option.enabled");
      var bootstrapConfig = bootstrapHandler.get(module);
      var rootToggle = this.entryBuilder().startBooleanToggle(rootI18n, bootstrapConfig.enabled).setDefaultValue(() -> false).setSaveConsumer(b -> {
        bootstrapConfig.enabled = b;
        saveQueue.put(bootstrapConfig, () -> bootstrapHandler.save(module));
      }).requireRestart().build();
      if (moduleCategory.isEmpty()) {
        category.addEntry(ClothTooltipUtil.standardForModule(rootToggle, module, "enabled"));
      } else {
        moduleCategory.add(0, rootToggle);
        category.addEntry(ClothTooltipUtil.standardForModule(moduleCategory.build(), module, null));
      }
    }
    return builder.build();
  }

  private static <T> EntryContext<T> makeRootCtx(T value, T def, Consumer<T> consumer, String i18n, Module module) {
    return new EntryContext<>(value.getClass(), value, def, consumer, i18n, null, module);
  }


  public record EntryContext<T>(Class<?> type, T value, @Nullable T def, Consumer<T> consumer, String i18n, Field field, Module module) {
    /**
     * @return a clone of this object, except with this updated property (returns {@code this} if an identical value is passed).
     */
    public AutoConfigScreen.EntryContext<T> withType(final Class<?> type) {
      return this.type == type ? this : new AutoConfigScreen.EntryContext<T>(type, this.value, this.def, this.consumer, this.i18n, this.field, this.module);
    }

    /**
     * @return a clone of this object, except with this updated property (returns {@code this} if an identical value is passed).
     */
    public AutoConfigScreen.EntryContext<T> withValue(final T value) {
      return this.value == value ? this : new AutoConfigScreen.EntryContext<T>(this.type, value, this.def, this.consumer, this.i18n, this.field, this.module);
    }

    /**
     * @return a clone of this object, except with this updated property (returns {@code this} if an identical value is passed).
     */
    public AutoConfigScreen.EntryContext<T> withDef(@Nullable final T def) {
      return this.def == def ? this : new AutoConfigScreen.EntryContext<T>(this.type, this.value, def, this.consumer, this.i18n, this.field, this.module);
    }

    /**
     * @return a clone of this object, except with this updated property (returns {@code this} if an identical value is passed).
     */
    public AutoConfigScreen.EntryContext<T> withConsumer(final Consumer<T> consumer) {
      return this.consumer == consumer ? this : new AutoConfigScreen.EntryContext<T>(this.type, this.value, this.def, consumer, this.i18n, this.field, this.module);
    }

    /**
     * @return a clone of this object, except with this updated property (returns {@code this} if an identical value is passed).
     */
    public AutoConfigScreen.EntryContext<T> withI18n(final String i18n) {
      return this.i18n == i18n ? this : new AutoConfigScreen.EntryContext<T>(this.type, this.value, this.def, this.consumer, i18n, this.field, this.module);
    }

    /**
     * @return a clone of this object, except with this updated property (returns {@code this} if an identical value is passed).
     */
    public AutoConfigScreen.EntryContext<T> withField(final Field field) {
      return this.field == field ? this : new AutoConfigScreen.EntryContext<T>(this.type, this.value, this.def, this.consumer, this.i18n, field, this.module);
    }

    /**
     * @return a clone of this object, except with this updated property (returns {@code this} if an identical value is passed).
     */
    public AutoConfigScreen.EntryContext<T> withModule(final Module module) {
      return this.module == module ? this : new AutoConfigScreen.EntryContext<T>(this.type, this.value, this.def, this.consumer, this.i18n, this.field, module);
    }
  }


  public interface EntryFunction<T> {
    AbstractConfigListEntry<?> getEntry(EntryContext<T> context);
  }


  public record Entry<T>(EntryFunction<T> function, Function<Class<?>, T> def) {
  }
}
