package dev.zenfyr.andromeda.common.client.config;

import dev.zenfyr.andromeda.bootstrap.Module;
import dev.zenfyr.andromeda.bootstrap.ModuleHelper;
import dev.zenfyr.pulsar.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5224;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import org.apache.commons.lang3.ArrayUtils;

public class ClothTooltipUtil {

  public static <T extends AbstractConfigListEntry<?>> T standardForModule(
      T e, Module module, String field) {
    setModuleTooltip(e, module);
    appendDeprecationTooltip(e, module);
    return wrapTooltip(e);
  }

  public static <T extends AbstractConfigListEntry<?>> T setModuleTooltip(T e, Module module) {
    if (e instanceof TooltipListEntry<?> t) {
      String s = "config.andromeda.%s.@Tooltip".formatted(ModuleHelper.dotted(module));
      if (!class_1074.method_4663(s)) return e;

      var opt = Optional.of(new class_2561[] {TextUtil.translatable(s)});
      t.setTooltipSupplier(() -> opt);
    }
    return e;
  }

  public static <T extends AbstractConfigListEntry<?>> T setEntryTooltip(T e, String option) {
    if (e instanceof TooltipListEntry<?> t) {
      if (class_1074.method_4663(option)) {
        var opt = Optional.of(new class_2561[] {TextUtil.translatable(option)});
        t.setTooltipSupplier(() -> opt);
        return e;
      }
      t.setTooltipSupplier(Optional::empty);
    }
    return e;
  }

  public static <T extends AbstractConfigListEntry<?>> T appendDeprecationTooltip(
      T e, Module module) {
    if (e instanceof TooltipListEntry<?> t) {
      if (!module.getClass().isAnnotationPresent(Deprecated.class)) return e;
      appendTooltipText(
          t,
          TextUtil.translatable("andromeda.config.tooltip.deprecated")
              .method_27692(class_124.field_1061));
    }
    return e;
  }

  public static <T extends TooltipListEntry<?>> T appendTooltipText(T t, class_2561 text) {
    var supplier = t.getTooltipSupplier();
    Optional<class_2561[]> tooltip;
    if (supplier != null) {
      tooltip =
          Optional.of(supplier.get().map(texts -> ArrayUtils.add(texts, text)).orElseGet(() ->
              new class_2561[] {text}));
    } else {
      tooltip = Optional.of(new class_2561[] {text});
    }
    t.setTooltipSupplier(() -> tooltip);
    return t;
  }

  public static <T extends AbstractConfigListEntry<?>> T wrapTooltip(T e) {
    if (e instanceof TooltipListEntry<?> t) {
      var supplier = t.getTooltipSupplier();
      if (supplier == null) return e;
      var opt = supplier.get().map(texts -> {
        List<class_2561> wrapped = new ArrayList<>();
        for (class_2561 text : texts) {
          wrapped.addAll(ClothTooltipUtil.wrap(text, 250));
        }
        return wrapped.toArray(class_2561[]::new);
      });
      t.setTooltipSupplier(() -> opt);
    }
    return e;
  }

  public static List<class_2561> wrap(class_2561 text, int length) {
    return class_310.method_1551().field_1772.method_1728(text, length).stream()
        .map(ClothTooltipUtil::orderedToNormal)
        .toList();
  }

  // author: kyrptonaught
  public static class_2561 orderedToNormal(class_5481 orderedText) {
    class_5250 text = TextUtil.empty();
    class_5224 characterVisitor = (index, style, codePoint) -> {
      String str = new String(Character.toChars(codePoint));
      text.method_10852(TextUtil.literal(str).method_10862(style));
      return true;
    };
    orderedText.accept(characterVisitor);
    return text;
  }
}
