package dev.zenfyr.andromeda.common.mixin;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7655;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_7655.class)
abstract class RegistryLoaderMixin {

  @WrapOperation(
      method =
          "loadRegistryContents(Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/core/WritableRegistry;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V",
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;",
              remap = false))
  private static DataResult<?> andromeda$cancelDecode(
      Decoder<?> instance,
      DynamicOps<?> ops,
      Object input,
      Operation<DataResult<?>> original,
      @Local class_2960 identifier,
      @Local JsonElement json) {
    // Only applying to Andromeda because this is very untested.
    if (identifier.method_12836().equals("andromeda")
        && json.isJsonObject()
        && !ResourceConditions.objectMatchesConditions(json.getAsJsonObject())) return null;

    return original.call(instance, ops, input);
  }

  @WrapOperation(
      method =
          "loadRegistryContents(Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/core/WritableRegistry;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V",
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lcom/mojang/serialization/DataResult;getOrThrow(ZLjava/util/function/Consumer;)Ljava/lang/Object;",
              remap = false))
  private static Object andromeda$cancelGetOrThrow(
      DataResult<?> instance,
      boolean allowPartial,
      Consumer<String> onError,
      Operation<?> original) {
    return instance == null ? null : original.call(instance, allowPartial, onError);
  }

  @WrapWithCondition(
      method =
          "loadRegistryContents(Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/core/WritableRegistry;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V",
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/core/WritableRegistry;register(Lnet/minecraft/resources/ResourceKey;Ljava/lang/Object;Lcom/mojang/serialization/Lifecycle;)Lnet/minecraft/core/Holder$Reference;"))
  private static boolean andromeda$cancelEntryAddition(
      class_2385<?> instance, class_5321<?> tRegistryKey, Object t, Lifecycle lifecycle) {
    return t != null;
  }
}
