package dev.zenfyr.andromeda.common.util;

import dev.zenfyr.andromeda.bootstrap.Module;
import dev.zenfyr.andromeda.bootstrap.ModuleHelper;
import dev.zenfyr.andromeda.bootstrap.event.bus.Bus;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.pulsar.creativetab.CreativeModeTabBuilder;
import dev.zenfyr.pulsar.util.TextUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_5321;

public interface AndromedaItemGroup {

  Bus<AndromedaItemGroup> BUS = Bus.create(AndromedaItemGroup.class, events -> acceptor -> {
    for (AndromedaItemGroup event : events) {
      event.onCreateItemGroup(acceptor);
    }
  });

  void onCreateItemGroup(Acceptor acceptor);

  static class_1761 create() {
    return CreativeModeTabBuilder.create(Andromeda.id("group"))
        .entries(entries -> {
          Map<Module, List<class_1799>> stackMap = new LinkedHashMap<>();
          AndromedaItemGroup.Acceptor acceptor = (module, main, stack) -> {
            if (!stack.method_7960()) {
              stackMap.computeIfAbsent(module, module1 -> new ArrayList<>()).add(stack);
            }
          };
          BUS.invoker().onCreateItemGroup(acceptor);
          Map<Module, List<class_1799>> small = new LinkedHashMap<>();
          Map<Module, List<class_1799>> big = new LinkedHashMap<>();
          if (stackMap.isEmpty()) {
            entries.add(class_1802.field_8077);
            return;
          }
          stackMap.forEach((module, itemStacks) -> {
            if (itemStacks.size() > 2) {
              big.put(module, itemStacks);
            } else if (!itemStacks.isEmpty()) {
              small.put(module, itemStacks);
            }
          });
          if (small.isEmpty() && big.isEmpty()) {
            entries.add(class_1802.field_8077);
            return;
          }
          List<class_1799> stacks = new ArrayList<>();
          small.forEach((m, itemStacks) -> {
            class_1799 sign = new class_1799(class_1802.field_8111);
            sign.method_7977(
                TextUtil.translatable("config.andromeda.%s".formatted(ModuleHelper.dotted(m))));
            stacks.add(sign);
            stacks.addAll(itemStacks);
            stacks.add(class_1799.field_8037);
          });
          entries.appendStacks(stacks);
          big.forEach((m, itemStacks) -> {
            class_1799 sign = new class_1799(class_1802.field_8111);
            sign.method_7977(
                TextUtil.translatable("config.andromeda.%s".formatted(ModuleHelper.dotted(m))));
            itemStacks.add(0, sign);
            entries.appendStacks(itemStacks);
          });
        })
        .displayName(TextUtil.translatable("itemGroup.andromeda.items"))
        .build();
  }

  interface Acceptor {
    void stack(Module module, class_5321<class_1761> main, class_1799 stack);

    default void stacks(Module module, class_5321<class_1761> main, List<class_1799> stacks) {
      for (class_1799 stack : stacks) {
        stack(module, main, stack);
      }
    }

    default <T extends class_1935> void items(
        Module module, class_5321<class_1761> main, List<T> items) {
      stacks(module, main, items.stream().map(class_1799::new).toList());
    }

    default <T extends class_1935> void item(
        Module module, class_5321<class_1761> main, T item) {
      stack(module, main, new class_1799(item));
    }

    default <T extends class_1935> void keepers(
        Module module,
        class_5321<class_1761> main,
        List<Keeper<? extends class_1935>> keepers) {
      stacks(
          module,
          main,
          keepers.stream()
              .filter(Keeper::isPresent)
              .map(Keeper::orThrow)
              .map(class_1799::new)
              .toList());
    }

    default <T extends class_1935> void keeper(
        Module module, class_5321<class_1761> main, Keeper<T> keeper) {
      if (keeper.isPresent()) stack(module, main, new class_1799(keeper.orThrow()));
    }
  }
}
