package dev.zenfyr.andromeda.common.util;

import dev.zenfyr.pulsar.util.functions.Memoize;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.NonNull;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
// Wrapper for a LootContextParameterSet.Builder to add our utility methods.
public class LootContextBuilder {
  class_8567.class_8568 builder;

  private LootContextBuilder(class_1937 world) {
    this.builder = new class_8567.class_8568((class_3218) world);
  }

  public static Supplier<class_47> builder(class_176 type, class_1937 world, BuilderFunction function) {
    return Memoize.supplier(() -> build(function.apply(new LootContextBuilder(world)).builder.method_51875(type)));
  }

  public static Supplier<class_47> block(class_1937 world, BuilderFunction function) {
    return builder(class_173.field_1172, world, function);
  }

  public static Supplier<class_47> fishing(class_1937 world, BuilderFunction function) {
    return builder(class_173.field_1176, world, function);
  }

  public static Supplier<class_47> command(class_1937 world, BuilderFunction function) {
    return builder(class_173.field_20761, world, function);
  }

  public static Supplier<class_47> entity(class_1937 world, BuilderFunction function) {
    return builder(class_173.field_1173, world, function);
  }

  public static class_47 build(class_8567 set) {
    return new class_47.class_48(set).method_309(null);
  }

  public static List<class_1799> prepareLoot(@NonNull class_1937 world, @NonNull class_2960 lootId) {
    if (world == null) {
      throw new NullPointerException("world is marked non-null but is null");
    }
    if (lootId == null) {
      throw new NullPointerException("lootId is marked non-null but is null");
    }
    return ((class_3218) world).method_8503().method_3857().getLootTable(lootId).method_51878(new class_8567.class_8568(((class_3218) world)).method_51875(class_173.field_1175));
  }

  public LootContextBuilder origin(class_2338 pos) {
    return this.origin(class_243.method_24953(pos));
  }

  public LootContextBuilder origin(class_1297 entity) {
    return this.origin(entity.method_19538());
  }

  public LootContextBuilder origin(class_243 pos) {
    this.builder.method_51877(class_181.field_24424, pos);
    return this;
  }

  public LootContextBuilder state(class_2680 state) {
    this.builder.method_51877(class_181.field_1224, state);
    return this;
  }

  public LootContextBuilder tool(class_1309 player, class_1268 hand) {
    return this.tool(player.method_5998(hand));
  }

  public LootContextBuilder tool(@Nullable class_1799 stack) {
    this.builder.method_51877(class_181.field_1229, Objects.requireNonNullElse(stack, class_1799.field_8037));
    return this;
  }

  public LootContextBuilder thisEntity(class_1297 entity) {
    this.builder.method_51877(class_181.field_1226, entity);
    return this;
  }

  public LootContextBuilder killer(class_1297 entity) {
    this.builder.method_51877(class_181.field_1230, entity);
    return this;
  }

  public LootContextBuilder directKiller(class_1297 entity) {
    this.builder.method_51877(class_181.field_1227, entity);
    return this;
  }

  public LootContextBuilder blockEntity(class_2586 entity) {
    this.builder.method_51877(class_181.field_1228, entity);
    return this;
  }

  public LootContextBuilder source(class_1282 source) {
    this.builder.method_51877(class_181.field_1231, source);
    return this;
  }

  public LootContextBuilder genericSource() {
    return this.source(builder.method_51870().method_48963().method_48830());
  }

  public LootContextBuilder sourceOrGeneric(class_1282 source) {
    return source != null ? this.source(source) : this.genericSource();
  }


  public interface BuilderFunction {
    LootContextBuilder apply(LootContextBuilder builder);
  }
}
