package dev.zenfyr.andromeda.modules.blocks.fletching_table_tweaks;

import static dev.zenfyr.andromeda.common.Andromeda.id;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.util.Debug;
import java.util.*;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.minecraft.class_8047;

public class FletchingScreenHandler extends class_4861 {

  public static final Keeper<class_3917<FletchingScreenHandler>> FLETCHING = Keeper.create();

  public FletchingScreenHandler(int syncId, class_1661 playerInventory) {
    this(syncId, playerInventory, class_3914.field_17304);
  }

  public FletchingScreenHandler(
      int syncId, class_1661 playerInventory, class_3914 context) {
    super(FLETCHING.orThrow(), syncId, playerInventory, context);
  }

  @Override
  public boolean method_24927(class_1657 player, boolean present) {
    return !this.field_22479.method_5442();
  }

  @Override
  protected void method_24923(class_1657 player, class_1799 stack) {
    stack.method_7982(player.method_37908(), player, stack.method_7947());
    this.field_22479.method_7664(
        player, List.of(this.field_22480.method_5438(0), this.field_22480.method_5438(1)));
    this.decrementStack(0);
    this.decrementStack(1);
    this.field_22481.method_17393((world, pos) -> world.method_20290(1044, pos, 0));
  }

  private void decrementStack(int slot) {
    class_1799 itemStack = this.field_22480.method_5438(slot);
    itemStack.method_7934(1);
    this.field_22480.method_5447(slot, itemStack);
  }

  // This should probably be data-driven, but whatever.
  private static final Map<class_1856, Map<class_1856, Function<class_1799, class_1799>>> RECIPES =
      new HashMap<>();

  public static void addRecipe(
      Function<class_1799, class_1799> consumer, class_1856 ingredient, class_1856 input) {
    RECIPES.computeIfAbsent(input, i -> new IdentityHashMap<>()).put(ingredient, consumer);
  }

  @Override
  public void method_24928() {
    class_1799 stack = method_7611(0).method_7677();

    var lookup = RECIPES.entrySet().stream()
        .filter(e -> e.getKey().method_8093(stack))
        .flatMap(e -> e.getValue().entrySet().stream())
        .collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    if (lookup.isEmpty()) {
      method_7611(2).method_48931(class_1799.field_8037);
      return;
    }

    class_1799 stack1 = method_7611(1).method_7677();
    var recipe = lookup.entrySet().stream().filter(e -> e.getKey().method_8093(stack1)).findFirst();
    if (recipe.isEmpty()) {
      method_7611(2).method_48931(class_1799.field_8037);
      return;
    }

    method_7611(2).method_48931(recipe.get().getValue().apply(stack));
  }

  @Override
  protected class_8047 method_48352() {
    return class_8047.method_48364()
        .method_48374(0, 27, 47, stack -> true)
        .method_48374(1, 76, 47, stack -> true)
        .method_48373(0, 134, 47)
        .method_48372();
  }

  @Override
  protected boolean method_24925(class_2680 state) {
    return state.method_27852(class_2246.field_16331);
  }

  @Override
  public boolean method_7613(class_1799 stack, class_1735 slot) {
    return slot.field_7871 != this.field_22479 && super.method_7613(stack, slot);
  }

  static void init() {
    var module = ModuleManager.get().get(FletchingTableTweaks.class).orElseThrow();
    FletchingScreenHandler.FLETCHING.init(class_2378.method_10230(
        class_7923.field_41187,
        id("fletching"),
        new class_3917<>(FletchingScreenHandler::new, class_7699.method_45397())));

    Set<class_1792> tightable = Sets.newHashSet(class_1802.field_8102, class_1802.field_8399);

    if (Debug.get().isModLoaded(module, "additionaladditions")) {
      class_7923.field_41178
          .method_17966(class_2960.method_43902("additionaladditions", "crossbow_with_spyglass"))
          .ifPresent(item -> {
            tightable.add(item);
            FletchingScreenHandler.addRecipe(
                stack -> {
                  var result = new class_1799(item, 1);
                  if (stack.method_7969() != null) result.method_7980(stack.method_7969());
                  return result;
                },
                class_1856.method_8091(class_1802.field_27070),
                class_1856.method_8091(class_1802.field_8399));
          });
    }

    FletchingScreenHandler.addRecipe(
        stack -> {
          class_2487 nbt = stack.method_7948();
          int i = nbt.method_10550("AM-Tightened");
          if (i >= 32) return class_1799.field_8037;

          class_1799 newStack = stack.method_7972();
          newStack.method_7948().method_10569("AM-Tightened", Math.min(i + 2, 32));
          return newStack;
        },
        class_1856.method_8091(class_1802.field_8276),
        class_1856.method_8091(tightable.toArray(class_1935[]::new)));
  }
}
