package dev.zenfyr.andromeda.modules.blocks.guarded_loot.mixin;

import static dev.zenfyr.andromeda.modules.blocks.guarded_loot.Main.*;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_2621.class)
abstract class LootableContainerBlockEntityMixin extends class_2624 {

  protected LootableContainerBlockEntityMixin(
      class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
    super(blockEntityType, blockPos, blockState);
  }

  @ModifyExpressionValue(
      at =
          @At(
              value = "INVOKE",
              target = "Lnet/minecraft/world/entity/player/Player;isSpectator()Z"),
      method = "canOpen")
  private boolean lockedIfMonstersNearby(boolean locked, @Local(argsOnly = true) class_1657 player) {
    var monsters =
        checkMonsterLock(player.field_6002, this.method_11010(), player, this.method_11016(), this);
    if (monsters.isEmpty() || player.method_31549().field_7477 || checkLockPicking(this, player))
      return locked;

    handleLockedContainer(player, monsters);
    return true;
  }
}
