package dev.zenfyr.andromeda.modules.entities.bee_flower_duplication.mixin;

import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.util.LootContextBuilder;
import dev.zenfyr.andromeda.modules.entities.bee_flower_duplication.BeeFlowerDuplication;
import dev.zenfyr.andromeda.modules.misc.unknown.RoseOfTheValley;
import dev.zenfyr.andromeda.modules.misc.unknown.Unknown;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2487;
import net.minecraft.class_2521;
import net.minecraft.class_2680;
import net.minecraft.class_4466;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_4466.class)
abstract class BeeEntityMixin extends class_1429 {

  @Shadow
  @Nullable class_2338 savedFlowerPos;

  @Shadow
  class_4466.class_4478 beePollinateGoal;

  @Unique private int andromeda$plantingCoolDown;

  protected BeeEntityMixin(class_1299<? extends class_1429> entityType, class_1937 world) {
    super(entityType, world);
  }

  @Inject(
      at =
          @At(
              value = "INVOKE",
              target = "Lnet/minecraft/world/entity/animal/Animal;tick()V",
              shift = At.Shift.AFTER),
      method = "tick")
  private void andromeda$tick(CallbackInfo ci) {
    if (this.andromeda$plantingCoolDown > 0) this.andromeda$plantingCoolDown--;

    if (this.beePollinateGoal != null) {
      if (this.beePollinateGoal.method_23346()
          && this.beePollinateGoal.method_21820()
          && this.andromeda$canPlant()) {
        this.andromeda$growFlower();
      }
    }
  }

  @Inject(at = @At("TAIL"), method = "addAdditionalSaveData")
  private void andromeda$writeNbt(class_2487 nbt, CallbackInfo ci) {
    if (this.andromeda$plantingCoolDown != 0)
      nbt.method_10569("AM-plantingCoolDown", this.andromeda$plantingCoolDown);
  }

  @Inject(at = @At("TAIL"), method = "readAdditionalSaveData")
  private void andromeda$readNbt(class_2487 nbt, CallbackInfo ci) {
    if (nbt.method_10545("AM-plantingCoolDown"))
      this.andromeda$plantingCoolDown = nbt.method_10550("AM-plantingCoolDown");
  }

  @Unique private void andromeda$growFlower() {
    if (this.savedFlowerPos != null) {
      class_2680 flowerState = field_6002.method_8320(savedFlowerPos);
      var config = field_6002.am$get(BeeFlowerDuplication.CONFIG);
      var supplier =
          LootContextBuilder.block(field_6002, builder -> builder.origin(method_19538()).state(flowerState));
      if (!config.available) return;

      if (flowerState.method_26204() instanceof class_2356 flowerBlock) {
        andromeda$plantingCoolDown = field_6002.field_9229.method_39332(3600, 6490);
        for (int i = -2; i <= 2; i++) {
          for (int b = -2; b <= 2; b++) {
            for (int c = -2; c <= 2; c++) {
              class_2338 pos = new class_2338(
                  savedFlowerPos.method_10263() + i, savedFlowerPos.method_10264() + b, savedFlowerPos.method_10260() + c);
              if (field_6002.method_8320(pos).method_26204() instanceof class_2189
                  && flowerBlock.method_9558(flowerState, field_6002, pos)) {
                if (field_6002.field_9229.method_43048(12) == 0) {
                  if (ModuleManager.get().get(Unknown.class).isPresent()
                      && field_6002.field_9229.method_43048(100) == 0) {
                    field_6002.method_8501(
                        pos,
                        RoseOfTheValley.ROSE_OF_THE_VALLEY_BLOCK.orThrow().method_9564());
                  } else {
                    field_6002.method_8501(pos, flowerState);
                  }
                }
              }
            }
          }
        }
      } else if (flowerState.method_26204() instanceof class_2521 flowerBlock
          && config.tallFlowers) {
        andromeda$plantingCoolDown = field_6002.field_9229.method_39332(3600, 8000);
        for (int i = -1; i <= 1; i++) {
          for (int b = -2; b <= 2; b++) {
            for (int c = -1; c <= 1; c++) {
              class_2338 pos = new class_2338(
                  savedFlowerPos.method_10263() + i, savedFlowerPos.method_10264() + b, savedFlowerPos.method_10260() + c);
              if (field_6002.method_8320(pos).method_26204() instanceof class_2189
                  && flowerBlock.method_9558(flowerState, field_6002, pos)) {
                if (field_6002.field_9229.method_43048(6) == 0) {
                  class_2521.method_10021(field_6002, flowerState, pos, class_2248.field_31028);
                }
              }
            }
          }
        }
      }
    }
  }

  @Unique private boolean andromeda$canPlant() {
    return this.andromeda$plantingCoolDown == 0;
  }
}
