package dev.zenfyr.andromeda.modules.entities.boats;

import static dev.zenfyr.andromeda.common.Andromeda.id;

import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.modules.entities.boats.entities.FurnaceBoatEntity;
import dev.zenfyr.andromeda.modules.entities.boats.entities.HopperBoatEntity;
import dev.zenfyr.andromeda.modules.entities.boats.entities.JukeboxBoatEntity;
import dev.zenfyr.andromeda.modules.entities.boats.entities.TNTBoatEntity;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BoatEntities {

  public static final Keeper<class_1299<TNTBoatEntity>> BOAT_WITH_TNT = Keeper.create();
  public static final Keeper<class_1299<FurnaceBoatEntity>> BOAT_WITH_FURNACE = Keeper.create();
  public static final Keeper<class_1299<JukeboxBoatEntity>> BOAT_WITH_JUKEBOX = Keeper.create();
  public static final Keeper<class_1299<HopperBoatEntity>> BOAT_WITH_HOPPER = Keeper.create();

  private static @Nullable <T extends class_1297> class_1299<T> boatType(
      boolean register, class_2960 id, class_1299.class_4049<T> factory) {
    if (register) {
      return class_2378.method_10230(
          class_7923.field_41177,
          id,
          FabricEntityTypeBuilder.create(class_1311.field_17715, factory)
              .dimensions(new class_4048(1.375F, 0.5625F, true))
              .build());
    } else {
      return null;
    }
  }

  public static void init() {
    var config = Andromeda.MAIN.get(Boats.MAIN_CONFIG);
    BOAT_WITH_TNT.init(boatType(config.isTNTBoatOn, id("tnt_boat"), TNTBoatEntity::new));
    BOAT_WITH_FURNACE.init(
        boatType(config.isFurnaceBoatOn, id("furnace_boat"), FurnaceBoatEntity::new));
    BOAT_WITH_JUKEBOX.init(
        boatType(config.isJukeboxBoatOn, id("jukebox_boat"), JukeboxBoatEntity::new));
    BOAT_WITH_HOPPER.init(
        boatType(config.isHopperBoatOn, id("hopper_boat"), HopperBoatEntity::new));

    if (BOAT_WITH_TNT.isPresent()) {
      // This sucks
      ServerPlayNetworking.registerGlobalReceiver(
          TNTBoatEntity.EXPLODE_BOAT_ON_SERVER, (server, player, handler, buf, responseSender) -> {
            UUID id = buf.method_10790();
            server.execute(() -> {
              class_1297 entity = player.field_6002.method_31592().method_31808(id);
              if (entity instanceof TNTBoatEntity boat
                  && boat.method_5805()
                  && player == boat.method_31483()) boat.explode();
            });
          });
    }
  }
}
