package dev.zenfyr.andromeda.modules.entities.boats;

import static dev.zenfyr.andromeda.common.Andromeda.id;

import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.AndromedaItemGroup;
import dev.zenfyr.andromeda.modules.entities.boats.items.AndromedaBoatItem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class BoatItems {

  public static void init() {
    var module = ModuleManager.get().get(Boats.class).orElseThrow();
    var config = Andromeda.MAIN.get(Boats.MAIN_CONFIG);

    List<class_1792> list = new ArrayList<>();
    for (class_1690.class_1692 value : class_1690.class_1692.values()) {
      if (config.isFurnaceBoatOn) {
        list.add(class_2378.method_10230(
            class_7923.field_41178,
            boatId(value, "furnace"),
            new AndromedaBoatItem<>(
                BoatEntities.BOAT_WITH_FURNACE, value, new FabricItemSettings().method_7889(1))));
      }

      if (config.isJukeboxBoatOn) {
        list.add(class_2378.method_10230(
            class_7923.field_41178,
            boatId(value, "jukebox"),
            new AndromedaBoatItem<>(
                BoatEntities.BOAT_WITH_JUKEBOX, value, new FabricItemSettings().method_7889(1))));
      }

      if (config.isTNTBoatOn) {
        list.add(class_2378.method_10230(
            class_7923.field_41178,
            boatId(value, "tnt"),
            new AndromedaBoatItem<>(
                BoatEntities.BOAT_WITH_TNT, value, new FabricItemSettings().method_7889(1))));
      }

      if (config.isHopperBoatOn) {
        list.add(class_2378.method_10230(
            class_7923.field_41178,
            boatId(value, "hopper"),
            new AndromedaBoatItem<>(
                BoatEntities.BOAT_WITH_HOPPER, value, new FabricItemSettings().method_7889(1))));
      }
    }
    AndromedaItemGroup.BUS.listen(
        acceptor -> acceptor.items(module, class_7706.field_41060, list));
  }

  public static class_2960 boatId(class_1690.class_1692 type, String boat) {
    return id(type.method_7559().replace(":", "_") + "_boat_with_" + boat);
  }
}
