package dev.zenfyr.andromeda.modules.entities.boats.client;

import dev.zenfyr.andromeda.modules.entities.boats.BoatEntities;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_3865;

public class Client {

  public static void init() {
    var map = Map.of(
        BoatEntities.BOAT_WITH_FURNACE,
        class_2246.field_10181.method_9564().method_11657(class_3865.field_11104, class_2350.field_11043),
        BoatEntities.BOAT_WITH_JUKEBOX,
        class_2246.field_10223.method_9564(),
        BoatEntities.BOAT_WITH_TNT,
        class_2246.field_10375.method_9564(),
        BoatEntities.BOAT_WITH_HOPPER,
        class_2246.field_10312.method_9564());

    map.forEach((keeper, blockState) -> {
      if (keeper.isPresent()) {
        EntityRendererRegistry.register(
            keeper.get(), ctx -> new BoatWithBlockRenderer(ctx, blockState));
      }
    });

    if (BoatEntities.BOAT_WITH_JUKEBOX.isPresent()) ClientSoundHolder.init();
  }
}
