package dev.zenfyr.andromeda.modules.entities.boats.client;

import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.pulsar.util.MakeSure;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_638;

public class ClientSoundHolder {

  public static final class_2960 JUKEBOX_START_PLAYING =
      Andromeda.id("jukebox_start_playing");
  public static final class_2960 JUKEBOX_STOP_PLAYING = Andromeda.id("jukebox_stop_playing");

  private static volatile boolean done = false;
  private static final Map<UUID, PersistentMovingSoundInstance> soundInstanceMap = new HashMap<>();

  public static void init() {
    if (done) return;

    ClientPlayNetworking.registerGlobalReceiver(
        JUKEBOX_START_PLAYING, (client, handler, buf, responseSender) -> {
          UUID id = buf.method_10790();
          class_1799 stack = buf.method_10819();
          client.execute(() -> {
            class_1297 entity =
                MakeSure.notNull(client.field_1687, "client.world").method_31592().method_31808(id);
            if (stack.method_7909() instanceof class_1813 disc) {
              var discName = disc.method_8011();
              soundInstanceMap.computeIfAbsent(id, k -> {
                var instance = new PersistentMovingSoundInstance(
                    disc.method_8009(), class_3419.field_15247, id, client.field_1687, class_5819.method_43047());
                client.method_1483().method_4873(instance);
                return instance;
              });
              if (discName != null) {
                if (client.field_1724 != null
                    && entity != null
                    && entity.method_5739(client.field_1724) < 76) {
                  client.field_1705.method_1732(discName);
                }
              }
            }
          });
        });
    ClientPlayNetworking.registerGlobalReceiver(
        JUKEBOX_STOP_PLAYING, (client, handler, buf, responseSender) -> {
          UUID id = buf.method_10790();
          client.execute(() -> {
            class_1113 instance = soundInstanceMap.remove(id);
            if (client.method_1483().method_4877(instance))
              client.method_1483().method_4870(instance);
          });
        });

    done = true;
  }

  public static class PersistentMovingSoundInstance extends class_1101 {

    private final class_638 world;
    private final UUID entityId;

    public PersistentMovingSoundInstance(
        class_3414 soundEvent,
        class_3419 soundCategory,
        UUID entityId,
        class_638 world,
        class_5819 random) {
      super(soundEvent, soundCategory, random);
      this.field_5442 = 3;
      this.field_5441 = 1;
      this.world = world;
      this.entityId = entityId;
    }

    @Override
    public void method_16896() {
      class_1297 entity = world.method_31592().method_31808(entityId);
      if (entity != null) {
        this.field_5442 = 3;
        this.field_5439 = entity.method_23317();
        this.field_5450 = entity.method_23318();
        this.field_5449 = entity.method_23321();
      } else {
        // this sucks
        this.field_5442 = 0;
      }
    }
  }
}
