package dev.zenfyr.andromeda.modules.entities.boats.items;

import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.common.util.MiscUtil;
import dev.zenfyr.pulsar.util.MakeSure;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3959;
import net.minecraft.class_5712;

public class AndromedaBoatItem<T extends class_1690> extends class_1792 {

  private static final Predicate<class_1297> RIDERS =
      class_1301.field_6155.and(class_1297::method_5863);
  private final class_1690.class_1692 type;
  private final Keeper<class_1299<T>> keeper;

  public AndromedaBoatItem(Keeper<class_1299<T>> keeper, class_1690.class_1692 type, class_1793 settings) {
    super(settings);
    this.keeper = keeper;
    this.type = type;
    class_2315.method_10009(this, new BoatDispenseBehavior());
  }

  @Override
  public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
    class_1799 itemStack = user.method_5998(hand);
    class_239 hitResult = method_7872(world, user, class_3959.class_242.field_1347);
    if (hitResult.method_17783() == class_239.class_240.field_1333) {
      return class_1271.method_22430(itemStack);
    } else {
      class_243 vec3d = user.method_5828(1.0F);
      List<class_1297> list = world.method_8333(
          user, user.method_5829().method_18804(vec3d.method_1021(5.0)).method_1014(1.0), RIDERS);
      if (!list.isEmpty()) {
        class_243 vec3d2 = user.method_33571();

        for (class_1297 entity : list) {
          class_238 box = entity.method_5829().method_1014(entity.method_5871());
          if (box.method_1006(vec3d2)) {
            return class_1271.method_22430(itemStack);
          }
        }
      }

      if (hitResult.method_17783() == class_239.class_240.field_1332) {
        T furnace = MakeSure.notNull(this.keeper.orThrow().method_5883(world));
        furnace.method_5814(
            hitResult.method_17784().field_1352, hitResult.method_17784().field_1351, hitResult.method_17784().field_1350);

        furnace.method_47884(this.type);
        furnace.method_36456(user.method_36454());
        if (!world.method_8587(furnace, furnace.method_5829())) {
          return class_1271.method_22431(itemStack);
        } else {
          if (!world.field_9236) {
            world.method_8649(furnace);
            world.method_33596(
                user, class_5712.field_28738, MiscUtil.vec3dAsBlockPos(hitResult.method_17784()));
            if (!user.method_31549().field_7477) {
              itemStack.method_7934(1);
            }
          }

          user.method_7259(class_3468.field_15372.method_14956(this));
          return class_1271.method_29237(itemStack, world.method_8608());
        }
      } else {
        return class_1271.method_22430(itemStack);
      }
    }
  }

  private class BoatDispenseBehavior extends class_2347 {

    private final class_2347 itemDispenser;

    public BoatDispenseBehavior() {
      this.itemDispenser = new class_2347();
    }

    @Override
    protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
      class_2350 direction = pointer.method_10120().method_11654(class_2315.field_10918);
      class_1937 world = pointer.method_10207();
      double d = 0.5625 + class_1299.field_6121.method_17685() / 2.0;
      double e = pointer.method_10216() + direction.method_10148() * d;
      double f = pointer.method_10214() + direction.method_10164() * 1.125F;
      double g = pointer.method_10215() + direction.method_10165() * d;
      class_2338 blockPos = pointer.method_10122().method_10093(direction);
      double h;
      if (world.method_8316(blockPos).method_15767(class_3486.field_15517)) {
        h = 1.0;
      } else {
        if (!world.method_8320(blockPos).method_26215()
            || !world.method_8316(blockPos.method_10074()).method_15767(class_3486.field_15517)) {
          return this.itemDispenser.dispense(pointer, stack);
        }
        h = 0.0;
      }

      T boatEntity = MakeSure.notNull(AndromedaBoatItem.this.keeper.orThrow().method_5883(world));
      boatEntity.method_5814(e, f + h, g);

      boatEntity.method_47884(AndromedaBoatItem.this.type);
      boatEntity.method_36456(direction.method_10144());

      world.method_8649(boatEntity);
      stack.method_7934(1);
      return stack;
    }
  }
}
