package dev.zenfyr.andromeda.modules.entities.furnace_minecart_tweaks.mixin;

import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.modules.entities.furnace_minecart_tweaks.FurnaceMinecartTweaks;
import dev.zenfyr.pulsar.itemstack.ItemStackUtil;
import dev.zenfyr.pulsar.reflection.Reflect;
import dev.zenfyr.pulsar.util.ExceptionUtil;
import dev.zenfyr.pulsar.util.SupportUtil;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Optional;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1696.class)
abstract class FurnaceMinecartIntakeMixin extends class_1688 {

  // stfu IDEA.
  @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
  @Unique private static final Optional<Field> fb$pauseFuel = SupportUtil.fallback(
      "fabrication",
      () -> Reflect.findField(class_1696.class, "fabrication$pauseFuel"),
      Optional::empty);

  @Shadow
  public int fuel;

  protected FurnaceMinecartIntakeMixin(class_1299<?> entityType, class_1937 world) {
    super(entityType, world);
  }

  @Inject(at = @At("HEAD"), method = "tick")
  private void andromeda$tick(CallbackInfo ci) {
    if (!Andromeda.MAIN.get(FurnaceMinecartTweaks.CONFIG).takeFuelWhenLow) return;

    if (!this.field_6002.method_8608() && this.fuel < 100) {
      if (field_6002.method_8510() % 20 == 0) {
        if (fb$pauseFuel
            .map(f -> ExceptionUtil.supply(() -> f.getInt(this)) > 0)
            .orElse(false)) return;

        class_1688 entity = this.field_6002
            .method_8390(
                class_1688.class,
                this.method_5829().method_1009(1.5, 0, 1.5),
                class_1263.class::isInstance)
            .stream()
            .min(Comparator.comparingDouble(value -> value.method_5858(this)))
            .orElse(null);

        if (entity instanceof class_1263 inventory) {
          for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (FuelRegistry.INSTANCE.get(stack.method_7909()) != null) {
              int itemFuel = FuelRegistry.INSTANCE.get(stack.method_7909());
              if ((this.fuel + (itemFuel * 2.25))
                  <= Andromeda.MAIN.get(FurnaceMinecartTweaks.CONFIG).maxFuel) {
                class_1799 reminder = stack.getRecipeRemainder();
                if (!reminder.method_7960())
                  ItemStackUtil.spawn(entity.method_19538(), stack.getRecipeRemainder(), field_6002);
                stack.method_7934(1);

                this.fuel += (int) (itemFuel * 2.25);
              }
              break;
            }
          }
        }
      }
    }
  }
}
