package dev.zenfyr.andromeda.modules.entities.ghast_tweaks.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.zenfyr.andromeda.modules.entities.ghast_tweaks.GhastExplosionDuck;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1927.class)
abstract class ExplosionMixin implements GhastExplosionDuck {

  @Shadow
  @Final
  private class_1937 level;

  @Unique private final ObjectArrayList<class_2338> affectedObsidian = new ObjectArrayList<>();

  @Unique private boolean affectObsidian = false;

  @Inject(
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/world/level/ExplosionDamageCalculator;getBlockExplosionResistance(Lnet/minecraft/world/level/Explosion;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/FluidState;)Ljava/util/Optional;"),
      method = "explode")
  private void collectAffectedObsidian(
      CallbackInfo ci,
      @Local(index = 14) float h,
      @Local(index = 22) class_2338 pos,
      @Local(index = 23) class_2680 state) {
    if (!affectObsidian || state.method_26204() != class_2246.field_10540) return;
    if (h - 0.64 > 0 && level.field_9229.method_43057() >= 0.2f) affectedObsidian.add(pos);
  }

  @Inject(
      at = @At(value = "FIELD", target = "Lnet/minecraft/world/level/Explosion;fire:Z"),
      method = "finalizeExplosion")
  private void affectObsidian(boolean particles, CallbackInfo ci) {
    for (class_2338 blockPos : affectedObsidian) {
      level.method_8501(blockPos, class_2246.field_22423.method_9564());
    }
  }

  @Override
  public void andromeda$convertObsidian(boolean b) {
    this.affectObsidian = b;
  }
}
