package dev.zenfyr.andromeda.modules.entities.minecarts;

import static dev.zenfyr.andromeda.common.Andromeda.id;

import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.modules.entities.minecarts.entities.AnvilMinecartEntity;
import dev.zenfyr.andromeda.modules.entities.minecarts.entities.JukeboxMinecartEntity;
import dev.zenfyr.andromeda.modules.entities.minecarts.entities.NoteBlockMinecartEntity;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_4048;
import net.minecraft.class_7923;

public class MinecartEntities {

  public static final Keeper<class_1299<AnvilMinecartEntity>> ANVIL_MINECART_ENTITY =
      Keeper.create();
  public static final Keeper<class_1299<NoteBlockMinecartEntity>> NOTEBLOCK_MINECART_ENTITY =
      Keeper.create();
  public static final Keeper<class_1299<JukeboxMinecartEntity>> JUKEBOX_MINECART_ENTITY =
      Keeper.create();

  static void init() {
    var config = Andromeda.MAIN.get(Minecarts.MAIN_CONFIG);

    if (config.isAnvilMinecartOn) {
      ANVIL_MINECART_ENTITY.init(class_2378.method_10230(
          class_7923.field_41177,
          id("anvil_minecart"),
          FabricEntityTypeBuilder.<AnvilMinecartEntity>create(
                  class_1311.field_17715, AnvilMinecartEntity::new)
              .dimensions(new class_4048(0.98F, 0.7F, true))
              .build()));
    }

    if (config.isNoteBlockMinecartOn) {
      NOTEBLOCK_MINECART_ENTITY.init(class_2378.method_10230(
          class_7923.field_41177,
          id("note_block_minecart"),
          FabricEntityTypeBuilder.<NoteBlockMinecartEntity>create(
                  class_1311.field_17715, NoteBlockMinecartEntity::new)
              .dimensions(new class_4048(0.98F, 0.7F, true))
              .build()));
    }

    if (config.isJukeboxMinecartOn) {
      JUKEBOX_MINECART_ENTITY.init(class_2378.method_10230(
          class_7923.field_41177,
          id("jukebox_minecart"),
          FabricEntityTypeBuilder.<JukeboxMinecartEntity>create(
                  class_1311.field_17715, JukeboxMinecartEntity::new)
              .dimensions(new class_4048(0.98F, 0.7F, true))
              .build()));
    }
  }
}
