package dev.zenfyr.andromeda.modules.entities.minecarts;

import static dev.zenfyr.andromeda.common.Andromeda.id;

import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.AndromedaItemGroup;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.modules.entities.minecarts.entities.AnvilMinecartEntity;
import dev.zenfyr.andromeda.modules.entities.minecarts.items.AndromedaMinecartItem;
import dev.zenfyr.andromeda.modules.entities.minecarts.items.JukeboxMinecartItem;
import dev.zenfyr.andromeda.modules.entities.minecarts.items.NoteBlockMinecartItem;
import dev.zenfyr.andromeda.modules.entities.minecarts.items.SpawnerMinecartItem;
import dev.zenfyr.andromeda.modules.items.minecart_block_picking.MinecartBlockPicking;
import dev.zenfyr.andromeda.modules.items.minecart_block_picking.PickUpBehaviorHandler;
import dev.zenfyr.pulsar.nbt.CompoundTagBuilder;
import dev.zenfyr.pulsar.util.MakeSure;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2428;
import net.minecraft.class_2487;
import net.minecraft.class_2619;
import net.minecraft.class_2636;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_6088;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class MinecartItems {

  public static final Keeper<SpawnerMinecartItem> SPAWNER_MINECART = Keeper.create();
  public static final Keeper<AndromedaMinecartItem<AnvilMinecartEntity>> ANVIL_MINECART =
      Keeper.create();
  public static final Keeper<NoteBlockMinecartItem> NOTE_BLOCK_MINECART = Keeper.create();
  public static final Keeper<JukeboxMinecartItem> JUKEBOX_MINECART = Keeper.create();

  public static void init() {
    var module = ModuleManager.get().get(Minecarts.class).orElseThrow();
    var config = Andromeda.MAIN.get(Minecarts.MAIN_CONFIG);

    if (config.isSpawnerMinecartOn) {
      SPAWNER_MINECART.init(class_2378.method_10230(
          class_7923.field_41178,
          id("spawner_minecart"),
          new SpawnerMinecartItem(new FabricItemSettings().method_7889(1))));
    }

    if (config.isSpawnerMinecartOn) {
      SPAWNER_MINECART.init(class_2378.method_10230(
          class_7923.field_41178,
          id("spawner_minecart"),
          new SpawnerMinecartItem(new FabricItemSettings().method_7889(1))));
    }

    if (config.isAnvilMinecartOn) {
      ANVIL_MINECART.init(class_2378.method_10230(
          class_7923.field_41178,
          id("anvil_minecart"),
          new AndromedaMinecartItem<>(
              MinecartEntities.ANVIL_MINECART_ENTITY, new FabricItemSettings().method_7889(1))));
    }

    if (config.isNoteBlockMinecartOn) {
      NOTE_BLOCK_MINECART.init(class_2378.method_10230(
          class_7923.field_41178,
          id("note_block_minecart"),
          new NoteBlockMinecartItem(new FabricItemSettings().method_7889(1))));
    }

    if (config.isJukeboxMinecartOn) {
      JUKEBOX_MINECART.init(class_2378.method_10230(
          class_7923.field_41178,
          id("jukebox_minecart"),
          new JukeboxMinecartItem(new FabricItemSettings().method_7889(1))));
    }

    var l = List.of(SPAWNER_MINECART, ANVIL_MINECART, NOTE_BLOCK_MINECART, JUKEBOX_MINECART);
    AndromedaItemGroup.BUS.listen(
        acceptor -> acceptor.keepers(module, class_7706.field_41060, List.copyOf(l)));

    if (ModuleManager.get().get(MinecartBlockPicking.class).isPresent()) {
      if (SPAWNER_MINECART.isPresent()) {
        PickUpBehaviorHandler.registerPickUpBehavior(class_2246.field_10260, (state, world, pos) -> {
          if (world.am$get(MinecartBlockPicking.CONFIG).spawnerPicking) {
            class_2636 mobSpawnerBlockEntity = (class_2636) MakeSure.notNull(
                world.method_8321(pos), "Block has no block entity. %s".formatted(pos));
            class_1799 spawnerMinecart = new class_1799(SPAWNER_MINECART.orThrow(), 1);
            spawnerMinecart.method_7980(CompoundTagBuilder.create()
                .putString("Entity", String.valueOf(andromeda$getEntityId(mobSpawnerBlockEntity)))
                .build());
            return spawnerMinecart;
          }
          return null;
        });
      }

      if (ANVIL_MINECART.isPresent()) {
        PickUpBehaviorHandler.registerPickUpBehavior(
            class_2246.field_10535, (state, world, pos) -> new class_1799(ANVIL_MINECART.orThrow()));
      }

      if (NOTE_BLOCK_MINECART.isPresent()) {
        PickUpBehaviorHandler.registerPickUpBehavior(class_2246.field_10179, (state, world, pos) -> {
          class_2428 noteBlock = (class_2428) state.method_26204();
          int noteProp = noteBlock.method_34725(state).method_11654(class_2741.field_12524);
          class_1799 noteBlockMinecart = new class_1799(NOTE_BLOCK_MINECART.orThrow());

          noteBlockMinecart.method_7980(
              CompoundTagBuilder.create().putInt("Note", noteProp).build());
          return noteBlockMinecart;
        });
      }

      if (JUKEBOX_MINECART.isPresent()) {
        PickUpBehaviorHandler.registerPickUpBehavior(class_2246.field_10223, (state, world, pos) -> {
          class_2619 jukeboxBlockEntity = (class_2619) MakeSure.notNull(
              world.method_8321(pos), "Block has no block entity. %s".formatted(pos));

          class_1799 record = jukeboxBlockEntity.method_5438(0);
          class_1799 jukeboxMinecart = new class_1799(JUKEBOX_MINECART.orThrow());

          if (!record.method_7960()) {
            world.method_20290(class_6088.field_42760, pos, 0);
            jukeboxMinecart.method_7980(CompoundTagBuilder.create()
                .put("Items", record.method_7953(new class_2487()))
                .build());
          }
          jukeboxBlockEntity.method_5448();
          return jukeboxMinecart;
        });
      }
    }
  }

  @Nullable private static class_2960 andromeda$getEntityId(class_2636 mobSpawnerBlockEntity) {
    var entry = mobSpawnerBlockEntity.method_11390().field_9155;
    if (entry == null) return class_7923.field_41177.method_10137();
    String identifier = entry.comp_64().method_10558("id");

    try {
      return StringUtils.isEmpty(identifier)
          ? class_7923.field_41177.method_10137()
          : new class_2960(identifier);
    } catch (class_151 e) {
      class_2338 blockPos = mobSpawnerBlockEntity.method_11016();
      ModuleManager.get()
          .get(Minecarts.class)
          .orElseThrow()
          .logger()
          .error(
              "Invalid entity id '{}' at spawner {}:[{},{},{}]",
              identifier,
              Objects.requireNonNull(mobSpawnerBlockEntity.method_10997())
                  .method_27983()
                  .method_29177(),
              blockPos.method_10263(),
              blockPos.method_10264(),
              blockPos.method_10260());
      return class_7923.field_41177.method_10137();
    }
  }
}
