package dev.zenfyr.andromeda.modules.entities.minecarts.entities;

import dev.zenfyr.andromeda.modules.entities.boats.client.ClientSoundHolder;
import dev.zenfyr.andromeda.modules.entities.minecarts.MinecartEntities;
import dev.zenfyr.andromeda.modules.entities.minecarts.MinecartItems;
import dev.zenfyr.pulsar.itemstack.ItemStackUtil;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3829;
import net.minecraft.class_5712;

public class JukeboxMinecartEntity extends class_1688 implements class_3829 {

  public class_1799 record = class_1799.field_8037;

  public JukeboxMinecartEntity(
      class_1299<? extends JukeboxMinecartEntity> entityType, class_1937 world) {
    super(entityType, world);
  }

  public JukeboxMinecartEntity(class_1937 world, double x, double y, double z) {
    super(MinecartEntities.JUKEBOX_MINECART_ENTITY.orThrow(), world, x, y, z);
  }

  @Override
  public class_1689 method_7518() {
    return class_1689.field_7678;
  }

  @Override
  public void method_7506(int x, int y, int z, boolean powered) {
    if (powered && !this.record.method_7960()) {
      ItemStackUtil.spawnVelocity(
          new class_243(this.method_23317(), this.method_23318() + 0.5, this.method_23321()),
          this.record,
          this.field_6002,
          -0.2,
          0.2,
          0.1,
          0.2,
          -0.2,
          0.2);
      this.method_5448();
      this.stopPlaying();
    }
  }

  @Override
  public boolean method_5643(class_1282 source, float amount) {
    if (this.field_6002.field_9236 || this.method_31481()) {
      return true;
    } else if (this.method_5679(source)) {
      return false;
    } else {
      this.method_7524(-this.method_7522());
      this.method_7509(10);
      this.method_5785();
      this.method_7520(this.method_7521() + amount * 10.0F);
      this.method_32875(class_5712.field_28736, source.method_5529());
      boolean isCreativePlayer =
          source.method_5529() instanceof class_1657 player && player.method_31549().field_7477;
      if (isCreativePlayer || this.method_7521() > 40.0F) {
        this.method_5772();
        this.stopPlaying();
        if (isCreativePlayer && !this.method_16914()) {
          this.method_31472();
        } else {
          this.method_7516(source);
        }
      }

      return true;
    }
  }

  @Override
  public void method_7516(class_1282 damageSource) {
    super.method_7516(damageSource);
    if (this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
      this.method_5706(record.method_7909());
    }
  }

  @Override
  public void method_5768() {
    this.stopPlaying();
    this.method_5650(class_5529.field_26998);
  }

  @Override
  public class_1269 method_5688(class_1657 player, class_1268 hand) {
    class_1799 stackInHand = player.method_5998(hand);
    if (!field_6002.method_8608())
      if (!this.record.method_7960()) {
        ItemStackUtil.spawnVelocity(
            new class_243(this.method_23317(), this.method_23318() + 0.5, this.method_23321()),
            this.record,
            this.field_6002,
            -0.2,
            0.2,
            0.1,
            0.2,
            -0.2,
            0.2);
        this.stopPlaying();
        this.method_5448();
      } else if (stackInHand.method_7909() instanceof class_1813) {
        this.record = stackInHand.method_7972();
        this.startPlaying();
        stackInHand.method_7934(1);
        player.method_7281(class_3468.field_15375);
      }
    return class_1269.method_29236(this.field_6002.field_9236);
  }

  public void stopPlaying() {
    class_2540 buf = PacketByteBufs.create().method_10797(this.method_5667());

    for (class_1657 player1 : field_6002.method_18456()) {
      ServerPlayNetworking.send(
          (class_3222) player1, ClientSoundHolder.JUKEBOX_STOP_PLAYING, buf);
    }
  }

  public void startPlaying() {
    class_2540 buf = PacketByteBufs.create().method_10797(this.field_6021).method_10793(this.record);

    for (class_1657 player1 : field_6002.method_18456()) {
      ServerPlayNetworking.send(
          (class_3222) player1, ClientSoundHolder.JUKEBOX_START_PLAYING, buf);
    }
  }

  @Override
  public void method_5749(class_2487 nbt) {
    super.method_5749(nbt);
    if (nbt.method_10573("Items", 10)) {
      this.record = class_1799.method_7915(nbt.method_10562("Items"));
    }
  }

  @Override
  public void method_5652(class_2487 nbt) {
    super.method_5652(nbt);
    if (!this.record.method_7960()) nbt.method_10566("Items", this.record.method_7953(new class_2487()));
  }

  @Override
  public class_1792 method_42670() {
    return MinecartItems.JUKEBOX_MINECART.orThrow();
  }

  @Override
  public class_2680 method_7517() {
    return class_2246.field_10223.method_9564();
  }

  @Override
  public class_1799 method_31480() {
    return new class_1799(MinecartItems.JUKEBOX_MINECART.orThrow());
  }

  @Override
  public void method_5448() {
    this.record = class_1799.field_8037;
  }
}
