package dev.zenfyr.andromeda.modules.entities.minecarts.entities;

import dev.zenfyr.andromeda.modules.entities.minecarts.MinecartEntities;
import dev.zenfyr.andromeda.modules.entities.minecarts.MinecartItems;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2442;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2766;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3532;

public class NoteBlockMinecartEntity extends class_1688 {
  public int note = 0;
  public boolean isPowered = false;

  public NoteBlockMinecartEntity(
      class_1299<? extends NoteBlockMinecartEntity> entityType, class_1937 world) {
    super(entityType, world);
  }

  public NoteBlockMinecartEntity(class_1937 world, double x, double y, double z) {
    super(MinecartEntities.NOTEBLOCK_MINECART_ENTITY.orThrow(), world, x, y, z);
  }

  @Override
  public boolean method_5643(class_1282 source, float amount) {
    this.playNote(field_6002, new class_243(method_23317(), method_23318() - 1, method_23321()));
    super.method_5643(source, amount);
    return true;
  }

  @Override
  public class_1269 method_5688(class_1657 player, class_1268 hand) {
    this.cycleNote();
    this.playNote(field_6002, new class_243(method_23317(), method_23318() - 1, method_23321()));
    player.method_7281(class_3468.field_15393);
    return class_1269.method_29236(field_6002.field_9236);
  }

  @Override
  public void method_7506(int x, int y, int z, boolean powered) {
    if (powered && !this.isPowered) {
      playNote(this.field_6002, new class_243(method_23317(), method_23318() - 1, method_23321()));
    }
  }

  @Override
  public void method_5773() {
    int i = class_3532.method_15357(this.method_23317());
    int j = class_3532.method_15357(this.method_23318());
    int k = class_3532.method_15357(this.method_23321());
    if (this.field_6002.method_8320(new class_2338(i, j - 1, k)).method_26164(class_3481.field_15463)) {
      --j;
    }

    class_2338 blockPos = new class_2338(i, j, k);
    class_2680 blockState = this.field_6002.method_8320(blockPos);
    if (class_2241.method_9476(blockState)) {
      if (blockState.method_27852(class_2246.field_10546)) {
        if (blockState.method_11654(class_2442.field_11364)) {
          this.method_7506(i, j, k, true);
          this.isPowered = true;
        } else {
          this.isPowered = false;
        }
      } else {
        this.isPowered = false;
      }
    }
    super.method_5773();
  }

  @Override
  public class_1689 method_7518() {
    return class_1689.field_7678;
  }

  @Override
  public void method_5749(class_2487 nbt) {
    super.method_5749(nbt);
    this.note = nbt.method_10550("Note");
    this.isPowered = nbt.method_10577("Powered");
  }

  @Override
  public void method_5652(class_2487 nbt) {
    super.method_5652(nbt);
    nbt.method_10569("Note", this.note);
    nbt.method_10556("Powered", this.isPowered);
  }

  @Override
  public class_1792 method_42670() {
    return MinecartItems.NOTE_BLOCK_MINECART.orThrow();
  }

  @Override
  public class_2680 method_7517() {
    return class_2246.field_10179.method_9564();
  }

  @Override
  public class_1799 method_31480() {
    return new class_1799(MinecartItems.NOTE_BLOCK_MINECART.orThrow());
  }

  public void cycleNote() {
    int nextNote = this.note + 1;
    if (nextNote < class_2741.field_12524.method_30043().toList().size()) {
      this.note = nextNote;
    } else {
      this.note = 0;
    }
  }

  public void playNote(class_1937 world, class_243 pos) {
    class_2338 blockPos = new class_2338(class_3532.method_15357(pos.method_10216()), class_3532.method_15357(pos.method_10214()), class_3532.method_15357(pos.method_10215()));
    // BlockState state = world.getBlockState(blockPos);

    class_2766 instrument = world.method_8320(blockPos.method_10084()).method_51364();
    if (!instrument.method_51372()) {
      class_2766 instrument2 = world.method_8320(blockPos.method_10074()).method_51364();
      instrument = instrument2.method_51372() ? class_2766.field_12648 : instrument2;
    }

    int i = this.note;
    float f = (float) Math.pow(2.0, (i - 12) / 12.0);
    this.field_6002.method_8396(
        null,
        new class_2338(class_3532.method_15357(pos.method_10216()), class_3532.method_15357(pos.method_10214()), class_3532.method_15357(pos.method_10215())),
        instrument.method_11886().comp_349(),
        class_3419.field_15247,
        3.0F,
        f);
    this.field_6002.method_8406(class_2398.field_11224, pos.method_10216(), pos.method_10214() + 1.2, pos.method_10215(), i / 24.0, 0.0, 0.0);
  }
}
