package dev.zenfyr.andromeda.modules.entities.minecarts.items;

import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.pulsar.util.MakeSure;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3481;
import net.minecraft.class_5712;
import net.minecraft.class_6088;

public class AndromedaMinecartItem<T extends class_1688> extends class_1792 {

  private final Keeper<class_1299<T>> keeper;

  public AndromedaMinecartItem(Keeper<class_1299<T>> keeper, class_1793 settings) {
    super(settings);
    this.keeper = keeper;
    class_2315.method_10009(this, new MinecartDispenseBehavior());
  }

  protected void onCreate(class_1799 stack, T entity) {}

  @Override
  public class_1269 method_7884(class_1838 context) {
    class_1937 world = context.method_8045();
    class_2338 blockPos = context.method_8037();
    class_2680 blockState = world.method_8320(blockPos);
    if (!blockState.method_26164(class_3481.field_15463)) {
      return class_1269.field_5814;
    } else {
      class_1799 itemStack = context.method_8041();
      if (!world.field_9236) {
        class_2768 railShape = blockState.method_26204() instanceof class_2241
            ? blockState.method_11654(((class_2241) blockState.method_26204()).method_9474())
            : class_2768.field_12665;
        double d = 0.0;
        if (railShape.method_11897()) {
          d = 0.5;
        }

        T minecart = MakeSure.notNull(this.keeper.orThrow().method_5883(world));
        minecart.method_5814(
            (double) blockPos.method_10263() + 0.5,
            (double) blockPos.method_10264() + 0.0625 + d,
            (double) blockPos.method_10260() + 0.5);

        onCreate(itemStack, minecart);

        if (itemStack.method_7938()) {
          minecart.method_5665(itemStack.method_7964());
        }

        world.method_8649(minecart);
        world.method_33596(context.method_8036(), class_5712.field_28738, blockPos);
      }

      itemStack.method_7934(1);
      return class_1269.method_29236(world.field_9236);
    }
  }

  private class MinecartDispenseBehavior extends class_2347 {
    private final class_2347 defaultBehavior = new class_2347();

    @Override
    public class_1799 method_10135(class_2342 pointer, class_1799 stack) {
      class_2350 direction = pointer.method_10120().method_11654(class_2315.field_10918);
      class_1937 world = pointer.method_10207();

      class_2338 blockPos = pointer.method_10122().method_10093(direction);
      class_2680 blockState = world.method_8320(blockPos);
      class_2768 railShape = blockState.method_26204() instanceof class_2241
          ? blockState.method_11654(((class_2241) blockState.method_26204()).method_9474())
          : class_2768.field_12665;
      double g;
      if (blockState.method_26164(class_3481.field_15463)) {
        g = railShape.method_11897() ? 0.6 : 0.1;
      } else {
        if (!blockState.method_26215() || !world.method_8320(blockPos.method_10074()).method_26164(class_3481.field_15463)) {
          return this.defaultBehavior.dispense(pointer, stack);
        }

        class_2680 blockState2 = world.method_8320(blockPos.method_10074());
        class_2768 railShape2 = blockState2.method_26204() instanceof class_2241
            ? blockState2.method_11654(((class_2241) blockState2.method_26204()).method_9474())
            : class_2768.field_12665;
        g = direction != class_2350.field_11033 && railShape2.method_11897() ? -0.4 : -0.9;
      }

      double d = pointer.method_10216() + direction.method_10148() * 1.125;
      double e = Math.floor(pointer.method_10214()) + direction.method_10164();
      double f = pointer.method_10215() + direction.method_10165() * 1.125;

      T minecart = MakeSure.notNull(AndromedaMinecartItem.this.keeper.orThrow().method_5883(world));
      minecart.method_5814(d, e + g, f);

      onCreate(stack, minecart);

      if (stack.method_7938()) {
        minecart.method_5665(stack.method_7964());
      }

      world.method_8649(minecart);
      stack.method_7934(1);
      return stack;
    }

    @Override
    protected void method_10136(class_2342 pointer) {
      pointer.method_10207().method_20290(class_6088.field_31140, pointer.method_10122(), 0);
    }
  }
}
