package dev.zenfyr.andromeda.modules.entities.slimes.mixin.merge;

import dev.zenfyr.andromeda.modules.entities.slimes.Slimes;
import dev.zenfyr.pulsar.nbt.NbtUtil;
import dev.zenfyr.pulsar.util.MathUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1400;
import net.minecraft.class_1621;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1621.class)
abstract class SlimeEntityMixin extends class_1308 {

  @Shadow
  public abstract int getSize();

  @Shadow
  public abstract void setSize(int size, boolean heal);

  @Unique private int andromeda$mergeCD = MathUtil.nextInt(700, 2000);

  protected SlimeEntityMixin(class_1299<? extends class_1308> entityType, class_1937 world) {
    super(entityType, world);
  }

  @Inject(at = @At("TAIL"), method = "registerGoals")
  private void andromeda$newGoal(CallbackInfo ci) {
    var config = this.field_6002.am$get(Slimes.CONFIG);
    this.field_6185.method_6277(
        2,
        new class_1400<>(
            (class_1621) (Object) this, class_1621.class, 5, true, false, livingEntity -> {
              if (!config.available) return false;
              if (!config.merge) return false;
              if (this.andromeda$mergeCD > 0) return false;
              float d = livingEntity.method_5739(this);
              return d <= 6
                  && (getSize() <= config.maxMerge && ((class_1621) livingEntity).method_7152() < getSize());
            }));
  }

  @Inject(at = @At("TAIL"), method = "push")
  private void andromeda$push(class_1297 entity, CallbackInfo ci) {
    var config = this.field_6002.am$get(Slimes.CONFIG);
    if (!config.available) return;

    if (!config.merge) return;

    if (method_5968() instanceof class_1621 slime && slime == entity && this.andromeda$mergeCD == 0) {
      int size = (int) Math.round(slime.method_7152() * 0.75 + getSize() * 0.75);

      slime.method_31472();
      this.setSize(size, true);
      this.andromeda$mergeCD = MathUtil.nextInt(700, 2000);
    }
  }

  @Inject(at = @At("TAIL"), method = "tick")
  private void andromeda$tick(CallbackInfo ci) {
    if (this.andromeda$mergeCD > 0) --this.andromeda$mergeCD;
  }

  @Inject(at = @At("TAIL"), method = "addAdditionalSaveData")
  private void andromeda$writeNbt(class_2487 nbt, CallbackInfo ci) {
    nbt.method_10569("AM-MergeCD", Math.max(this.andromeda$mergeCD, 0));
  }

  @Inject(at = @At("TAIL"), method = "readAdditionalSaveData")
  private void andromeda$readNbt(class_2487 nbt, CallbackInfo ci) {
    this.andromeda$mergeCD = NbtUtil.getInt(nbt, "AM-MergeCD", MathUtil.nextInt(700, 2000));
  }
}
