package dev.zenfyr.andromeda.modules.entities.snowball_tweaks.mixin.layers;

import dev.zenfyr.andromeda.modules.entities.snowball_tweaks.Snowballs;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1680;
import net.minecraft.class_1682;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1682.class)
abstract class SnowballEntityMixin extends class_1676 {

  public SnowballEntityMixin(class_1299<? extends class_1676> entityType, class_1937 world) {
    super(entityType, world);
  }

  @Inject(at = @At("TAIL"), method = "tick()V")
  public void andromeda$onBlockHit(CallbackInfo ci) {
    if (!((class_1682) (Object) this instanceof class_1680)) return;
    if (field_6002.method_8608()) return;

    var config = field_6002.am$get(Snowballs.CONFIG);
    if (!config.available || !config.layers) return;

    class_243 pos = this.method_19538();
    class_243 vec3d = pos.method_1019(this.method_18798());
    // We need to recast, since vanilla ignores fluids.
    class_3965 hitResult = this.field_6002.method_17742(
        new class_3959(pos, vec3d, class_3959.class_3960.field_17558, class_3959.class_242.field_36338, this));

    if (hitResult.method_17783() == class_239.class_240.field_1332) {
      class_2338 blockPos = hitResult.method_17777();
      class_3610 fluidState = this.field_6002.method_8316(blockPos);
      if (fluidState.method_15769()) {
        class_2680 blockState = this.field_6002.method_8320(blockPos);
        if (!blockState.method_26215()) {
          if (blockState.method_27852(class_2246.field_10477)) {
            int i = blockState.method_11654(class_2488.field_11518);
            class_2680 placedState = i < 7
                ? blockState.method_11657(class_2488.field_11518, Math.min(8, i + 1))
                : class_2246.field_10491.method_9564();
            this.andromeda$setStateAndDiscard(blockPos, placedState);
            return;
          }

          class_2338 newPos = blockPos.method_10093(hitResult.method_17780());
          class_2680 newBlockState = this.field_6002.method_8320(newPos);
          if (newBlockState.method_27852(class_2246.field_10477)) {
            int i = newBlockState.method_11654(class_2488.field_11518);
            class_2680 placedState = i < 7
                ? newBlockState.method_11657(class_2488.field_11518, Math.min(8, i + 1))
                : class_2246.field_10491.method_9564();
            this.andromeda$setStateAndDiscard(newPos, placedState);
            return;
          }
          if (newBlockState.method_26215()) {
            class_2680 below = this.field_6002.method_8320(newPos.method_10074());
            if (!below.method_26215() && class_2246.field_10477.method_9564().method_26184(this.field_6002, newPos)) {
              this.andromeda$setStateAndDiscard(
                  newPos, class_2246.field_10477.method_9564().method_11657(class_2488.field_11518, 1));
              return;
            }
          }
          this.field_6002.method_8421(this, (byte) 3);
          this.method_31472();
        }
      } else {
        this.andromeda$setStateAndDiscard(blockPos, class_2246.field_10295.method_9564());
      }
    }
  }

  @Unique private void andromeda$setStateAndDiscard(class_2338 blockPos, class_2680 state) {
    this.field_6002.method_8652(blockPos, state, class_2248.field_31036);
    this.field_6002.method_8421(this, (byte) 3);
    this.method_31472();
  }
}
