package dev.zenfyr.andromeda.modules.gui.gui_particles.mixin;

import com.google.common.collect.Lists;
import dev.zenfyr.andromeda.common.client.AndromedaClient;
import dev.zenfyr.andromeda.modules.gui.gui_particles.GuiParticles;
import dev.zenfyr.pulsar.client.particles.ItemStackParticle;
import dev.zenfyr.pulsar.client.particles.ScreenParticleHelper;
import dev.zenfyr.pulsar.util.MathUtil;
import dev.zenfyr.pulsar.util.Utilities;
import java.util.*;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5289;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_5289.class)
abstract class GameModeSelectionScreenMixin extends class_437 {

  @Shadow
  protected abstract void method_25426();

  @Unique private static final List<class_1799> ANDROMEDA$ADVENTURE = Lists.newArrayList(
      class_1802.field_8251.method_7854(),
      class_1802.field_8895.method_7854(),
      class_1802.field_8204.method_7854());

  @Unique private static final List<class_1799> ANDROMEDA$SURVIVAL = Lists.newArrayList(
      class_1802.field_8371.method_7854(),
      class_1802.field_8279.method_7854(),
      class_1802.field_8477.method_7854(),
      class_1802.field_8370.method_7854(),
      class_1802.field_8511.method_7854(),
      class_1802.field_8634.method_7854());

  @Unique private static final List<class_1799> ANDROMEDA$SPECTATOR =
      Lists.newArrayList(class_1802.field_8449.method_7854());

  @Unique private static final Map<class_5289.class_5290, Supplier<class_1799>>
      ANDROMEDA$GAME_MODE_STACKS =
          Utilities.supply(new EnumMap<>(class_5289.class_5290.class), map -> {
            map.put(class_5289.class_5290.field_24576, () -> class_7923.field_41178
                .method_10240(class_5819.method_43047())
                .orElseThrow()
                .comp_349()
                .method_7854());
            map.put(
                class_5289.class_5290.field_24578,
                () -> Utilities.pickAtRandom(ANDROMEDA$ADVENTURE));
            map.put(
                class_5289.class_5290.field_24577,
                () -> Utilities.pickAtRandom(ANDROMEDA$SURVIVAL));
            map.put(
                class_5289.class_5290.field_24579,
                () -> Utilities.pickAtRandom(ANDROMEDA$SPECTATOR));
          });

  protected GameModeSelectionScreenMixin(class_2561 title) {
    super(title);
  }

  @Inject(
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/client/multiplayer/ClientPacketListener;sendUnsignedCommand(Ljava/lang/String;)Z",
              shift = At.Shift.BEFORE),
      method =
          "switchToHoveredGameMode(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/gui/screens/debug/GameModeSwitcherScreen$GameModeIcon;)V")
  private static void andromeda$gmSwitchParticles(
      class_310 client, class_5289.class_5290 gameMode, CallbackInfo ci) {
    if (!AndromedaClient.CLIENT.get(GuiParticles.CONFIG).gameModeSwitcherParticles) return;

    if (client.field_1755 instanceof class_5289 gameModeSelectionScreen) {
      List<class_5289.class_5291> buttonWidgets =
          new ArrayList<>(gameModeSelectionScreen.field_24573);
      buttonWidgets.removeIf(buttonWidget -> buttonWidget.field_24586 != gameMode);
      Optional<class_5289.class_5291> optional =
          buttonWidgets.stream().findFirst();

      if (optional.isPresent()) {
        class_5289.class_5291 widget = optional.get();
        double x = widget.method_46426() + widget.method_25368() / 2d;
        double y = widget.method_46427() + widget.method_25364() / 2d;

        if (ANDROMEDA$GAME_MODE_STACKS.containsKey(gameMode)) {
          ScreenParticleHelper.addParticles(
              () -> new ItemStackParticle(
                  x,
                  y,
                  MathUtil.nextDouble(-2, 2),
                  MathUtil.nextDouble(-2, 2),
                  ANDROMEDA$GAME_MODE_STACKS.get(gameMode).get()),
              5);
        } else {
          ScreenParticleHelper.addParticles(class_2398.field_11207, x, y, 0.5, 0.5, 0.07, 10);
        }
      }
    }
  }
}
