package dev.zenfyr.andromeda.modules.gui.item_frame_tooltips;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.zenfyr.pulsar.util.Utilities;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1533;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import org.joml.Vector2i;

public class Client {

  private Supplier<List<class_5684>> action;
  private float tooltipFlow;
  private float oldTooltipFlow;

  Client() {
    inGameTooltips();

    ClientTickEvents.START_CLIENT_TICK.register(client -> {
      var cast = client.field_1765;
      getCast(cast);
      oldTooltipFlow = tooltipFlow;
      tooltipFlow =
          action != null ? class_3532.method_16439(0.25f, tooltipFlow, 1) : class_3532.method_16439(0.1f, tooltipFlow, 0);
      if (Math.abs(tooltipFlow) < 1.0E-5F) tooltipFlow = 0;
    });
  }

  public static void registerEntityTooltip(
      Predicate<class_3966> predicate,
      Function<class_3966, List<class_5684>> function) {
    ENTITY_LOOKUP.put(predicate, function);
  }

  private void inGameTooltips() {
    HudRenderCallback.EVENT.register((context, delta) -> {
      if (class_310.method_1551().field_1755 == null) {
        var client = class_310.method_1551();

        if (action != null) {
          renderFromComponents(client, context, action.get());
        }
      }
    });

    registerEntityTooltip(
        entityHitResult -> entityHitResult.method_17782() instanceof class_1533 ife
            && !ife.method_6940().method_7960(),
        entityHitResult -> {
          var frameStack = ((class_1533) entityHitResult.method_17782()).method_6940();
          if (frameStack.method_7960()) return Collections.emptyList();

          var list = class_437.method_25408(class_310.method_1551(), frameStack);
          List<class_5684> components = list.stream()
              .map(class_2561::method_30937)
              .map(class_5684::method_32662)
              .collect(Collectors.toCollection(ArrayList::new));

          frameStack
              .method_32347()
              .ifPresent(datax -> components.add(1, Utilities.supply(() -> {
                class_5684 component =
                    TooltipComponentCallback.EVENT.invoker().getComponent(datax);
                if (component == null) component = class_5684.method_32663(datax);
                return component;
              })));
          return components;
        });
  }

  private static final Map<
          Predicate<class_3966>, Function<class_3966, List<class_5684>>>
      ENTITY_LOOKUP = new Reference2ObjectOpenHashMap<>();

  private void getCast(class_239 cast) {
    if (cast != null)
      if (cast.method_17783() == class_239.class_240.field_1331) {
        class_3966 hitResult = (class_3966) cast;
        var opt = ENTITY_LOOKUP.entrySet().stream()
            .filter(p -> p.getKey().test(hitResult))
            .findFirst();
        if (opt.isPresent()) {
          action = () -> opt.get().getValue().apply(hitResult);
          return;
        }
      }
    action = null;
  }

  private void renderFromComponents(
      class_310 client, class_332 context, List<class_5684> components) {
    if (components.isEmpty()) return;

    float flow = class_3532.method_16439(client.method_1488(), oldTooltipFlow, tooltipFlow);
    class_4587 matrices = context.method_51448();

    matrices.method_22903();
    matrices.method_46416(0, 0, -450);
    matrices.method_22905(1, 1, 1);
    RenderSystem.enableBlend();
    RenderSystem.defaultBlendFunc();
    RenderSystem.setShaderColor(1, 1, 1, Math.min(flow, 0.8f));

    context.method_51435(
        client.field_1772, components, 0, 0, (screenWidth, screenHeight, sameX, sameY, width, height) -> {
          float smoothX = ((screenWidth / 2f) - (flow * 15)) + 27;
          float smoothY = ((client.method_22683().method_4502() - height) / 2f);
          matrices.method_46416(smoothX - (int) smoothX, smoothY - (int) smoothY, 1);
          return new Vector2i((int) smoothX, (int) smoothY);
        });
    RenderSystem.setShaderColor(1, 1, 1, 1);
    RenderSystem.disableBlend();
    matrices.method_22909();
  }
}
