package dev.zenfyr.andromeda.modules.gui.name_tooltips.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.zenfyr.pulsar.util.MakeSure;
import dev.zenfyr.pulsar.util.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_329.class)
abstract class InGameHudMixin {
  @Shadow
  @Final
  private class_310 minecraft;

  @Shadow
  private int toolHighlightTimer;

  @Shadow
  private class_1799 lastToolHighlight;

  @Shadow
  private int screenHeight;

  @Inject(at = @At("HEAD"), method = "renderSelectedItemName", cancellable = true)
  private void andromeda$renderTooltip(class_332 context, CallbackInfo ci) {
    this.minecraft.method_16011().method_15396("selectedItemName");

    if (this.toolHighlightTimer > 0
        && !this.lastToolHighlight.method_7960()
        && class_310.method_1551().field_1755 == null) {
      int l = (int) ((float) this.toolHighlightTimer * 256.0F / 10.0F);
      if (l > 255) {
        l = 255;
      }

      if (l > 0) {
        int k = this.screenHeight - 59;
        if (!MakeSure.notNull(this.minecraft.field_1761).method_2908()) {
          k += 14;
        }

        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(0, 0, -450);
        matrices.method_22905(1, 1, 1);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor(1, 1, 1, Math.min(l / 255f, 0.8f));
        var list = class_437.method_25408(class_310.method_1551(), this.lastToolHighlight);
        List<class_5684> list1 = list.stream()
            .map(class_2561::method_30937)
            .map(class_5684::method_32662)
            .collect(Collectors.toCollection(ArrayList::new));

        this.lastToolHighlight
            .method_32347()
            .ifPresent(datax -> list1.add(1, Utilities.supply(() -> {
              class_5684 component =
                  TooltipComponentCallback.EVENT.invoker().getComponent(datax);
              if (component == null) component = class_5684.method_32663(datax);
              return component;
            })));

        int finalK = k;
        int finalL = l;
        context.method_51435(
            minecraft.field_1772, list1, 0, 0, (screenWidth, screenHeight, x, y, width, height) -> {
              float smoothX = ((screenWidth - width) / 2f);
              float smoothY = (finalK - height + (finalL / 255f * 2)) + 6;
              matrices.method_46416(smoothX - (int) smoothX, smoothY - (int) smoothY, 1);
              return new Vector2i((int) smoothX, (int) smoothY);
            });
        RenderSystem.setShaderColor(1, 1, 1, 1);
        RenderSystem.disableBlend();
        matrices.method_22909();
      }
    }

    this.minecraft.method_16011().method_15407();
    ci.cancel();
  }
}
