package dev.zenfyr.andromeda.modules.gui.smooth_tooltips.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import dev.zenfyr.andromeda.common.client.AndromedaClient;
import dev.zenfyr.andromeda.modules.gui.smooth_tooltips.SmoothTooltips;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import org.joml.Vector2d;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_332.class)
abstract class DrawContextMixin {

  @Shadow
  @Final
  private class_310 minecraft;

  @Shadow
  @Final
  private class_4587 pose;

  @Unique private static Vector2d smoothPos;

  @ModifyExpressionValue(
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;positionTooltip(IIIIII)Lorg/joml/Vector2ic;"),
      method =
          "renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V")
  private Vector2ic andromeda$smoothTooltip(
      Vector2ic vic,
      @Local(argsOnly = true, ordinal = 0) int x,
      @Local(argsOnly = true, ordinal = 1) int y,
      @Share("popMatrix") LocalBooleanRef popMatrix) {
    if (andromeda$makeSmooth(x, y)) {
      var c = AndromedaClient.CLIENT.get(SmoothTooltips.CONFIG);
      if (smoothPos == null) smoothPos = new Vector2d(x, y);
      smoothPos.x = class_3532.method_15350(
          class_3532.method_16436(c.deltaX * minecraft.method_1534(), smoothPos.x, vic.x()),
          vic.x() - c.clampX,
          vic.x() + c.clampX);
      smoothPos.y = class_3532.method_15350(
          class_3532.method_16436(c.deltaY * minecraft.method_1534(), smoothPos.y, vic.y()),
          vic.y() - c.clampY,
          vic.y() + c.clampY);

      popMatrix.set(true);
      this.pose.method_22903();
      this.pose.method_22904(smoothPos.x - (int) smoothPos.x, smoothPos.y - (int) smoothPos.y, 1);
      return new Vector2i((int) smoothPos.x, (int) smoothPos.y);
    }
    return vic;
  }

  @Unique private boolean andromeda$makeSmooth(int x, int y) {
    double mX = (this.minecraft.field_1729.method_1603()
        * this.minecraft.method_22683().method_4486()
        / this.minecraft.method_22683().method_4480());
    if ((int) mX != x) return false;
    double mY = (this.minecraft.field_1729.method_1604()
        * this.minecraft.method_22683().method_4502()
        / this.minecraft.method_22683().method_4507());
    return (int) mY == y;
  }

  @Inject(
      at = @At(value = "TAIL"),
      method =
          "renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V")
  private void andromeda$popMatrix(
      class_327 textRenderer,
      List<class_5684> components,
      int x,
      int y,
      class_8000 positioner,
      CallbackInfo ci,
      @Share("popMatrix") LocalBooleanRef popMatrix) {
    if (popMatrix.get()) this.pose.method_22909();
  }
}
