package dev.zenfyr.andromeda.modules.items.infinite_totem;

import static dev.zenfyr.andromeda.common.Andromeda.id;

import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.AndromedaItemGroup;
import dev.zenfyr.andromeda.common.util.Keeper;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public final class Main {

  public static final Keeper<class_1792> INFINITE_TOTEM = Keeper.create();
  public static final Keeper<class_2400> KNOCKOFF_TOTEM_PARTICLE = Keeper.create();

  public static final class_2960 USED_CUSTOM_TOTEM = Andromeda.id("used_custom_totem");
  public static final class_2960 NOTIFY_CLIENT =
      Andromeda.id("notify_client_about_stuff_please");

  static void init() {
    var module = ModuleManager.get().get(InfiniteTotem.class).orElseThrow();

    INFINITE_TOTEM.init(class_2378.method_10230(
        class_7923.field_41178,
        id("infinite_totem"),
        new class_1792(new FabricItemSettings().method_7889(1).method_7894(class_1814.field_8904))));

    KNOCKOFF_TOTEM_PARTICLE.init(class_2378.method_10230(
        class_7923.field_41180,
        id("knockoff_totem_particles"),
        FabricParticleTypes.simple()));

    AndromedaItemGroup.BUS.listen(
        acceptor -> acceptor.keeper(module, class_7706.field_40202, INFINITE_TOTEM));
  }
}
