package dev.zenfyr.andromeda.modules.items.infinite_totem.mixin;

import dev.zenfyr.andromeda.common.util.MiscUtil;
import dev.zenfyr.andromeda.modules.items.infinite_totem.BeaconUtil;
import dev.zenfyr.andromeda.modules.items.infinite_totem.InfiniteTotem;
import dev.zenfyr.andromeda.modules.items.infinite_totem.Main;
import dev.zenfyr.pulsar.util.tuple.Tuple;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1542.class)
abstract class ItemEntityMixin extends class_1297 {

  @Shadow
  public abstract void setNeverPickUp();

  @Shadow
  public abstract void setDefaultPickUpDelay();

  @Shadow
  public abstract class_1799 getItem();

  @Unique private static final Tuple<class_2580, Boolean> ANDROMEDA$NULL_BEACON =
      Tuple.of(null, false);

  @Unique private int andromeda$ascensionTicks;

  @Unique private class_1542 andromeda$itemEntity;

  @Unique private Tuple<class_2580, Boolean> andromeda$beacon = ANDROMEDA$NULL_BEACON;

  public ItemEntityMixin(class_1299<?> type, class_1937 world) {
    super(type, world);
  }

  @Inject(
      at =
          @At(
              value = "INVOKE",
              target = "Lnet/minecraft/world/entity/Entity;tick()V",
              shift = At.Shift.BEFORE),
      method = "tick")
  private void andromeda$tick(CallbackInfo ci) {
    if (this.field_6002.method_8608()) return;
    if (!this.getItem().method_31574(class_1802.field_8288)) return;
    var c = field_6002.am$get(InfiniteTotem.CONFIG);
    if (!c.available || !c.enableAscension) return;

    if (field_6012 % 35 == 0 && andromeda$ascensionTicks == 0) {
      if (!andromeda$beaconCheck()) {
        this.setDefaultPickUpDelay();
        if (andromeda$itemEntity != null) andromeda$itemEntity.method_6988();
      }
    }

    if (andromeda$beacon.left() != null && andromeda$beacon.right()) {
      if (andromeda$itemEntity == null) {
        if (andromeda$ascensionTicks > 0) --andromeda$ascensionTicks;

        if (field_6012 % 10 == 0) {
          Optional<class_1542> optional = field_6002
              .method_8390(
                  class_1542.class,
                  method_5829().method_1014(0.5),
                  itemEntity -> itemEntity.method_6983().method_31574(class_1802.field_8137)
                      && toMixin(itemEntity).andromeda$itemEntity == null)
              .stream()
              .findAny();

          if (optional.isPresent()) {
            andromeda$itemEntity = optional.get();
            toMixin(andromeda$itemEntity).andromeda$itemEntity = (class_1542) (Object) this;

            class_1799 targetStack = andromeda$itemEntity.method_6983();
            int count = targetStack.method_7947() - 1;
            if (count > 0) {
              class_1799 newStack = targetStack.method_7972();
              newStack.method_7939(count);
              targetStack.method_7939(1);

              andromeda$itemEntity.method_6979(targetStack);

              class_1542 entity = new class_1542(
                  field_6002,
                  andromeda$itemEntity.method_23317(),
                  andromeda$itemEntity.method_23318(),
                  andromeda$itemEntity.method_23321(),
                  newStack);
              field_6002.method_8649(entity);

              class_2540 buf = PacketByteBufs.create()
                  .method_10804(andromeda$itemEntity.method_5628())
                  .method_10793(targetStack);
              for (class_3222 serverPlayerEntity : PlayerLookup.tracking(this)) {
                ServerPlayNetworking.send(serverPlayerEntity, Main.NOTIFY_CLIENT, buf);
              }
            }

            andromeda$itemEntity.method_6989();
            this.setNeverPickUp();
          }
        }
      } else {
        if (andromeda$beaconCheck()) {
          andromeda$ascensionTicks++;

          MiscUtil.crudeSetVelocity(this, 0, 0.07, 0);
          MiscUtil.crudeSetVelocity(andromeda$itemEntity, 0, 0.07, 0);

          if (andromeda$ascensionTicks == 180) {
            andromeda$ascensionTicks = 0;

            ((class_3218) field_6002)
                .method_14199(
                    class_2398.field_11207, this.method_23317(), this.method_23318(), this.method_23321(), 15, 0, 0, 0, 0.4);

            class_1542 entity = new class_1542(
                field_6002,
                this.method_23317(),
                this.method_23318(),
                this.method_23321(),
                new class_1799(Main.INFINITE_TOTEM.orThrow()));
            this.method_31472();
            andromeda$itemEntity.method_31472();
            field_6002.method_8649(entity);
          }
        } else {
          this.setDefaultPickUpDelay();
          andromeda$itemEntity.method_6988();
          toMixin(andromeda$itemEntity).andromeda$itemEntity = null;

          andromeda$itemEntity = null;
        }
      }
    }
  }

  @Unique private static ItemEntityMixin toMixin(class_1542 entity) {
    return ((ItemEntityMixin) (Object) entity);
  }

  @Unique private boolean andromeda$beaconCheck() {
    class_2586 entity = field_6002.method_8321(new class_2338(
        (int) method_23317(),
        field_6002.method_8624(
                class_2902.class_2903.field_13202,
                method_24515().method_10263(),
                method_24515().method_10260())
            - 1,
        (int) method_23321()));
    if (entity instanceof class_2580 beaconBlock) {
      this.andromeda$beacon =
          Tuple.of(beaconBlock, BeaconUtil.matchesPattern(field_6002, beaconBlock.method_11016()));
      return true;
    } else {
      this.andromeda$beacon = ANDROMEDA$NULL_BEACON;
      return false;
    }
  }

  @Inject(at = @At("TAIL"), method = "readAdditionalSaveData")
  private void andromeda$readNbt(class_2487 nbt, CallbackInfo ci) {
    this.andromeda$ascensionTicks = nbt.method_10550("AM-Ascension");
  }

  @Inject(at = @At("TAIL"), method = "addAdditionalSaveData")
  private void andromeda$writeNbt(class_2487 nbt, CallbackInfo ci) {
    nbt.method_10569("AM-Ascension", this.andromeda$ascensionTicks);
  }
}
