package dev.zenfyr.andromeda.modules.items.informative_item_names.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.zenfyr.pulsar.util.TextUtil;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1799.class)
abstract class ItemStackMixin {

  @Shadow
  public abstract int getMaxDamage();

  @Shadow
  public abstract class_1792 getItem();

  @Shadow
  public abstract int getCount();

  @Shadow
  public abstract int getDamageValue();

  @Shadow
  public abstract class_1814 getRarity();

  @Inject(
      at =
          @At(
              value = "INVOKE",
              target = "Ljava/util/List;add(Ljava/lang/Object;)Z",
              ordinal = 0,
              shift = At.Shift.BEFORE),
      method = "getTooltipLines")
  private void andromeda$getTooltip(
      @Nullable class_1657 player,
      class_1836 context,
      CallbackInfoReturnable<List<class_2561>> cir,
      @Local class_5250 mutableText) {
    if (!this.getItem().method_7846()) {
      if (this.getCount() > 1)
        mutableText.method_10852(TextUtil.literal(" x" + this.getCount()).method_27692(getRarity().field_8908));
    } else {
      if (this.getDamageValue() > 0)
        mutableText.method_10852(TextUtil.literal(" "
                + ((this.getMaxDamage() - this.getDamageValue()) * 100 / this.getMaxDamage()) + "%")
            .method_27692(getRarity().field_8908));
    }
  }
}
